/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.openapi.aliyun.audit.service;

import cn.herodotus.stirrup.core.foundation.json.jackson2.utils.Jackson2Utils;
import cn.herodotus.stirrup.openapi.aliyun.audit.definition.domain.Response;
import cn.herodotus.stirrup.openapi.aliyun.audit.definition.service.AbstractScanService;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.text.TextResult;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.text.TextSyncRequest;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.text.TextSyncResponse;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.text.TextTask;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.green.model.v20180509.TextFeedbackRequest;
import com.aliyuncs.green.model.v20180509.TextScanRequest;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TextScanService
extends AbstractScanService {
    private static final Logger log = LoggerFactory.getLogger(TextScanService.class);
    private final TextScanRequest textScanRequest;
    private final TextFeedbackRequest textFeedbackRequest;

    public TextScanService(IAcsClient iAcsClient, TextScanRequest textScanRequest, TextFeedbackRequest textFeedbackRequest) {
        super(iAcsClient);
        this.textScanRequest = textScanRequest;
        this.textFeedbackRequest = textFeedbackRequest;
    }

    public Response<List<TextSyncResponse>> scan(TextSyncRequest textSyncRequest) {
        String jsonString = this.scan(textSyncRequest, this.textScanRequest);
        Response<List<TextSyncResponse>> entity = this.parseListResult(jsonString, TextSyncResponse.class);
        log.debug("[Herodotus] |- Aliyun Text Scan result is: {}", (Object)entity.toString());
        return entity;
    }

    public Response<String> feedback(List<TextFeedbackRequest> textFeedbackRequests) {
        String data = Jackson2Utils.toJson(textFeedbackRequests);
        String response = this.scan(data, this.textFeedbackRequest);
        Response<String> feedback = this.parseResult(response, String.class);
        log.debug("[Herodotus] |- Aliyun Text Feedback result is: {}", (Object)feedback.toString());
        return feedback;
    }

    public TextSyncRequest buildSyncRequest(List<TextTask> tasks, List<String> scenes, String bizType) {
        TextSyncRequest textSyncRequest = new TextSyncRequest();
        textSyncRequest.setBizType(bizType);
        textSyncRequest.setScenes(scenes);
        textSyncRequest.setTasks(tasks);
        return textSyncRequest;
    }

    public TextSyncRequest buildDefaultAsyncRequest(List<String> contents) {
        List<TextTask> tasks = contents.stream().map(content -> {
            TextTask textTask = new TextTask();
            textTask.setContent((String)content);
            return textTask;
        }).collect(Collectors.toList());
        ImmutableList scenes = ImmutableList.of((Object)"antispam");
        return this.buildSyncRequest(tasks, (List<String>)scenes, "security_Policy");
    }

    public boolean asyncAnalyse(List<TextSyncResponse> responses) {
        for (TextSyncResponse textSyncResponse : responses) {
            List textResults = textSyncResponse.getResults();
            for (TextResult textResult : textResults) {
                if (!textResult.getSuggestion().equals("block")) continue;
                log.warn("[Herodotus] |- Catch the block content: {}", (Object)textResult);
                return false;
            }
        }
        log.debug("[Herodotus] |- Content check result is ok!");
        return true;
    }

    public boolean executeScan(List<String> contents) {
        TextSyncRequest textSyncRequest = this.buildDefaultAsyncRequest(contents);
        Response<List<TextSyncResponse>> response = this.scan(textSyncRequest);
        if (ObjectUtils.isNotEmpty(response) && response.getCode().equals(200)) {
            return this.asyncAnalyse(response.getData());
        }
        log.error("[Herodotus] |- Aliyun Text Scan catch error! result: {}", response);
        return false;
    }
}

