/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.openapi.aliyun.audit.service;

import cn.herodotus.stirrup.openapi.aliyun.audit.definition.domain.CoreResponse;
import cn.herodotus.stirrup.openapi.aliyun.audit.definition.domain.Response;
import cn.herodotus.stirrup.openapi.aliyun.audit.definition.service.AbstractScanService;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.image.ImageAsyncRequest;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.image.ImageAsyncResponse;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.image.ImageQueryResponse;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.image.ImageSyncRequest;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.image.ImageSyncResponse;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.image.ImageTask;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.green.model.v20180509.ImageAsyncScanRequest;
import com.aliyuncs.green.model.v20180509.ImageAsyncScanResultsRequest;
import com.aliyuncs.green.model.v20180509.ImageSyncScanRequest;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ImageScanService
extends AbstractScanService {
    private static final Logger log = LoggerFactory.getLogger(ImageScanService.class);
    private final ImageSyncScanRequest imageSyncScanRequest;
    private final ImageAsyncScanRequest imageAsyncScanRequest;
    private final ImageAsyncScanResultsRequest imageAsyncScanResultsRequest;

    public ImageScanService(IAcsClient iAcsClient, ImageSyncScanRequest imageSyncScanRequest, ImageAsyncScanRequest imageAsyncScanRequest, ImageAsyncScanResultsRequest imageAsyncScanResultsRequest) {
        super(iAcsClient);
        this.imageSyncScanRequest = imageSyncScanRequest;
        this.imageAsyncScanRequest = imageAsyncScanRequest;
        this.imageAsyncScanResultsRequest = imageAsyncScanResultsRequest;
    }

    public Response<List<ImageSyncResponse>> syncScan(ImageSyncRequest imageSyncRequest) {
        String jsonString = this.scan(imageSyncRequest, this.imageSyncScanRequest);
        Response<List<ImageSyncResponse>> entity = this.parseListResult(jsonString, ImageSyncResponse.class);
        log.debug("[Herodotus] |- Aliyun Image Sync Scan result is: {}", (Object)entity.toString());
        return entity;
    }

    public Response<List<ImageAsyncResponse>> asyncScan(ImageAsyncRequest imageAsyncRequest) {
        String jsonString = this.scan(imageAsyncRequest, this.imageAsyncScanRequest);
        Response<List<ImageAsyncResponse>> entity = this.parseListResult(jsonString, ImageAsyncResponse.class);
        log.debug("[Herodotus] |- Aliyun Image Async Scan result is: {}", (Object)entity.toString());
        return entity;
    }

    public Response<List<ImageQueryResponse>> queryResult(List<String> taskIds) {
        String jsonString = this.query(taskIds, this.imageAsyncScanResultsRequest);
        Response<List<ImageQueryResponse>> entity = this.parseListResult(jsonString, ImageQueryResponse.class);
        log.debug("[Herodotus] |- Aliyun Image Async Scan Query Result is: {}", (Object)entity.toString());
        return entity;
    }

    public ImageAsyncRequest buildAsyncRequest(List<ImageTask> tasks, List<String> scenes, String bizType, String seed, String callback) {
        ImageAsyncRequest imageAsyncRequest = new ImageAsyncRequest();
        imageAsyncRequest.setBizType(bizType);
        imageAsyncRequest.setScenes(scenes);
        imageAsyncRequest.setTasks(tasks);
        if (StringUtils.isNotBlank((CharSequence)seed) && StringUtils.isNotBlank((CharSequence)callback)) {
            imageAsyncRequest.setSeed(seed);
            imageAsyncRequest.setCallback(callback);
        }
        return imageAsyncRequest;
    }

    public ImageAsyncRequest buildDefaultAsyncRequest(List<String> urls, String seed, String callback) {
        List<ImageTask> tasks = urls.stream().map(url -> {
            ImageTask imageTask = new ImageTask();
            imageTask.setUrl((String)url);
            return imageTask;
        }).collect(Collectors.toList());
        ImmutableList scenes = ImmutableList.of((Object)"porn", (Object)"terrorism", (Object)"ad");
        return this.buildAsyncRequest(tasks, (List<String>)scenes, "security_Policy", seed, callback);
    }

    public ImageAsyncRequest buildDefaultAsyncRequest(List<String> urls) {
        return this.buildDefaultAsyncRequest(urls, null, null);
    }

    public List<String> asyncAnalyse(List<ImageAsyncResponse> responses) {
        return responses.stream().map(CoreResponse::getTaskId).collect(Collectors.toList());
    }

    public List<String> executeScan(List<String> imageUrls) {
        return this.executeScan(imageUrls, null, null);
    }

    public List<String> executeScan(List<String> imageUrls, String seed, String callback) {
        ImageAsyncRequest imageAsyncRequest = this.buildDefaultAsyncRequest(imageUrls, seed, callback);
        Response<List<ImageAsyncResponse>> response = this.asyncScan(imageAsyncRequest);
        if (response.getCode().equals(200)) {
            return this.asyncAnalyse(response.getData());
        }
        log.error("[Herodotus] |- Aliyun Image Async Scan catch error! result: {}", response);
        return new ArrayList<String>();
    }
}

