/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.openapi.aliyun.audit.processor;

import cn.herodotus.stirrup.openapi.aliyun.audit.definition.service.AbstractScanChain;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.ScanRequest;
import cn.herodotus.stirrup.openapi.aliyun.audit.processor.ImageScanChain;
import cn.herodotus.stirrup.openapi.aliyun.audit.service.VideoScanService;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class VideoScanChain
extends AbstractScanChain {
    private static final Logger log = LoggerFactory.getLogger(VideoScanChain.class);
    private final VideoScanService videoScanService;
    private final ImageScanChain imageScanChain;

    public VideoScanChain(VideoScanService videoScanService, ImageScanChain imageScanChain) {
        this.videoScanService = videoScanService;
        this.imageScanChain = imageScanChain;
    }

    @Override
    public boolean execute(ScanRequest scanRequest) {
        List<String> videoUrls = scanRequest.getVideoUrls();
        if (CollectionUtils.isNotEmpty(videoUrls)) {
            this.videoScanService.executeScan(videoUrls);
        }
        return this.imageScanChain.execute(scanRequest);
    }
}

