/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.openapi.aliyun.audit.processor;

import cn.herodotus.stirrup.openapi.aliyun.audit.definition.service.AbstractScanChain;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.ScanRequest;
import cn.herodotus.stirrup.openapi.aliyun.audit.service.TextScanService;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.core.text.StrUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TextScanChain
extends AbstractScanChain {
    private static final Logger log = LoggerFactory.getLogger(TextScanChain.class);
    private static final int CONTENT_LENGTH = 10000;
    private final TextScanService textScanService;

    public TextScanChain(TextScanService textScanService) {
        this.textScanService = textScanService;
    }

    @Override
    public boolean execute(ScanRequest scanRequest) {
        String content = scanRequest.getText();
        if (StringUtils.isNotBlank((CharSequence)content)) {
            Object contents;
            int length = StrUtil.length((CharSequence)content);
            if (length > 10000) {
                String[] texts = StrUtil.cut((CharSequence)content, (int)10000);
                contents = Arrays.asList(texts);
            } else {
                contents = ImmutableList.of((Object)content);
            }
            return this.textScanService.executeScan((List<String>)contents);
        }
        return false;
    }
}

