/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.openapi.aliyun.audit.processor;

import cn.herodotus.stirrup.openapi.aliyun.audit.definition.service.AbstractScanChain;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.ScanRequest;
import cn.herodotus.stirrup.openapi.aliyun.audit.processor.TextScanChain;
import cn.herodotus.stirrup.openapi.aliyun.audit.service.ImageScanService;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ImageScanChain
extends AbstractScanChain {
    private static final Logger log = LoggerFactory.getLogger(ImageScanChain.class);
    private final ImageScanService imageScanService;
    private final TextScanChain textScanChain;

    public ImageScanChain(ImageScanService imageScanService, TextScanChain textScanChain) {
        this.imageScanService = imageScanService;
        this.textScanChain = textScanChain;
    }

    @Override
    public boolean execute(ScanRequest scanRequest) {
        List<String> imageUrls = scanRequest.getImageUrls();
        if (CollectionUtils.isNotEmpty(imageUrls)) {
            this.imageScanService.executeScan(imageUrls);
        }
        return this.textScanChain.execute(scanRequest);
    }
}

