/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.openapi.aliyun.audit.definition.service;

import cn.herodotus.stirrup.core.foundation.json.jackson2.utils.Jackson2Utils;
import cn.herodotus.stirrup.openapi.aliyun.audit.definition.domain.CoreRequest;
import cn.herodotus.stirrup.openapi.aliyun.audit.definition.domain.Response;
import com.aliyuncs.AcsResponse;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.RoaAcsRequest;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpResponse;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.dromara.hutool.core.text.StrUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScanService {
    private static final Logger log = LoggerFactory.getLogger(AbstractScanService.class);
    private final IAcsClient iAcsClient;

    protected AbstractScanService(IAcsClient iAcsClient) {
        this.iAcsClient = iAcsClient;
    }

    protected <R extends AcsResponse> String scan(CoreRequest coreRequest, RoaAcsRequest<R> roaAcsRequest) {
        String data = Jackson2Utils.toJson((Object)coreRequest);
        return this.scan(data, roaAcsRequest);
    }

    protected <R extends AcsResponse> String query(List<String> taskIds, RoaAcsRequest<R> roaAcsRequest) {
        String data = Jackson2Utils.toJson(taskIds);
        return this.scan(data, roaAcsRequest);
    }

    protected <R extends AcsResponse> String scan(String data, RoaAcsRequest<R> roaAcsRequest) {
        try {
            roaAcsRequest.setHttpContent(data.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8.name(), FormatType.JSON);
            HttpResponse httpResponse = this.iAcsClient.doAction(roaAcsRequest);
            if (httpResponse.isSuccess()) {
                String response = StrUtil.str((byte[])httpResponse.getHttpContent(), (Charset)StandardCharsets.UTF_8);
                log.debug("[Herodotus] |- Aliyun scan response is: {}", (Object)response);
                return response;
            }
            log.error("[Herodotus] |- Aliyun scan text cannot get response");
            return null;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun scan create client got an error!");
            return null;
        }
    }

    protected <P> Response<P> parseResult(String json, Class<P> clazz) {
        TypeFactory typeFactory = Jackson2Utils.getTypeFactory();
        JavaType javaType = typeFactory.constructParametricType(Response.class, new Class[]{clazz});
        return (Response)Jackson2Utils.toObject((String)json, (JavaType)javaType);
    }

    protected <P> Response<List<P>> parseListResult(String json, Class<P> clazz) {
        TypeFactory typeFactory = Jackson2Utils.getTypeFactory();
        JavaType list = typeFactory.constructParametricType(ArrayList.class, new Class[]{clazz});
        JavaType object = typeFactory.constructParametricType(Response.class, new JavaType[]{list});
        return (Response)Jackson2Utils.toObject((String)json, (JavaType)object);
    }

    protected <P> List<P> parseList(String json, Class<P> clazz) {
        ObjectMapper objectMapper = Jackson2Utils.getObjectMapper();
        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{clazz});
        return (List)Jackson2Utils.toObject((String)json, (JavaType)javaType);
    }
}

