/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.openapi.aliyun.audit.config;

import cn.herodotus.stirrup.openapi.aliyun.audit.annotation.ConditionalOnAliyunAuditConfigured;
import cn.herodotus.stirrup.openapi.aliyun.audit.properties.AliyunProperties;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.green.model.v20180509.ImageAsyncScanRequest;
import com.aliyuncs.green.model.v20180509.ImageAsyncScanResultsRequest;
import com.aliyuncs.green.model.v20180509.ImageSyncScanRequest;
import com.aliyuncs.green.model.v20180509.TextFeedbackRequest;
import com.aliyuncs.green.model.v20180509.TextScanRequest;
import com.aliyuncs.green.model.v20180509.VideoAsyncScanRequest;
import com.aliyuncs.green.model.v20180509.VideoAsyncScanResultsRequest;
import com.aliyuncs.green.model.v20180509.VideoSyncScanRequest;
import com.aliyuncs.green.model.v20180509.VoiceAsyncScanRequest;
import com.aliyuncs.green.model.v20180509.VoiceAsyncScanResultsRequest;
import com.aliyuncs.green.model.v20180509.VoiceSyncScanRequest;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import jakarta.annotation.PostConstruct;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnAliyunAuditConfigured
@EnableConfigurationProperties(value={AliyunProperties.class})
@ComponentScan(basePackages={"cn.herodotus.stirrup.openapi.aliyun.audit.service", "cn.herodotus.stirrup.openapi.aliyun.audit.processor"})
public class AliyunAuditConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AliyunAuditConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- Module [Aliyun Audit REST API] Auto Configure.");
    }

    @Bean
    @ConditionalOnMissingBean(value={IAcsClient.class})
    public IAcsClient iAcsClient(AliyunProperties aliyunProperties) {
        DefaultProfile iClientProfile = DefaultProfile.getProfile((String)aliyunProperties.getRegionId(), (String)aliyunProperties.getAccessKeyId(), (String)aliyunProperties.getAccessKeySecret());
        DefaultAcsClient iAcsClient = new DefaultAcsClient((IClientProfile)iClientProfile);
        log.trace("[Herodotus] |- Bean [IAcs Client] in AliyunScanConfiguration Auto Configure.");
        return iAcsClient;
    }

    @Bean
    public TextScanRequest textScanRequest(AliyunProperties aliyunProperties) {
        TextScanRequest textScanRequest = new TextScanRequest();
        textScanRequest.setSysAcceptFormat(FormatType.JSON);
        textScanRequest.setHttpContentType(FormatType.JSON);
        textScanRequest.setSysMethod(MethodType.POST);
        textScanRequest.setSysEncoding(StandardCharsets.UTF_8.name());
        textScanRequest.setSysRegionId(aliyunProperties.getRegionId());
        textScanRequest.setSysConnectTimeout(aliyunProperties.getAudit().getText().getConnectTimeout());
        textScanRequest.setSysReadTimeout(aliyunProperties.getAudit().getText().getReadTimeout());
        log.trace("[Herodotus] |- Bean [Text Scan Request] Auto Configure.");
        return textScanRequest;
    }

    @Bean
    public TextFeedbackRequest textFeedbackRequest(AliyunProperties aliyunProperties) {
        TextFeedbackRequest textFeedbackRequest = new TextFeedbackRequest();
        textFeedbackRequest.setSysAcceptFormat(FormatType.JSON);
        textFeedbackRequest.setHttpContentType(FormatType.JSON);
        textFeedbackRequest.setSysMethod(MethodType.POST);
        textFeedbackRequest.setSysEncoding(StandardCharsets.UTF_8.name());
        textFeedbackRequest.setSysRegionId(aliyunProperties.getRegionId());
        textFeedbackRequest.setSysConnectTimeout(aliyunProperties.getAudit().getText().getConnectTimeout());
        textFeedbackRequest.setSysReadTimeout(aliyunProperties.getAudit().getText().getReadTimeout());
        log.trace("[Herodotus] |- Bean [Text Feedback Request] Auto Configure.");
        return textFeedbackRequest;
    }

    @Bean
    public ImageSyncScanRequest imageSyncScanRequest(AliyunProperties aliyunProperties) {
        ImageSyncScanRequest imageSyncScanRequest = new ImageSyncScanRequest();
        imageSyncScanRequest.setSysAcceptFormat(FormatType.JSON);
        imageSyncScanRequest.setSysMethod(MethodType.POST);
        imageSyncScanRequest.setSysEncoding(StandardCharsets.UTF_8.name());
        imageSyncScanRequest.setSysProtocol(ProtocolType.HTTP);
        imageSyncScanRequest.setSysConnectTimeout(aliyunProperties.getAudit().getImage().getConnectTimeout());
        imageSyncScanRequest.setSysReadTimeout(aliyunProperties.getAudit().getImage().getReadTimeout());
        log.trace("[Herodotus] |- Bean [Image Sync Scan Request] Auto Configure.");
        return imageSyncScanRequest;
    }

    @Bean
    public ImageAsyncScanRequest imageAsyncScanRequest(AliyunProperties aliyunProperties) {
        ImageAsyncScanRequest imageAsyncScanRequest = new ImageAsyncScanRequest();
        imageAsyncScanRequest.setSysAcceptFormat(FormatType.JSON);
        imageAsyncScanRequest.setSysMethod(MethodType.POST);
        imageAsyncScanRequest.setSysEncoding(StandardCharsets.UTF_8.name());
        imageAsyncScanRequest.setSysProtocol(ProtocolType.HTTP);
        imageAsyncScanRequest.setSysConnectTimeout(aliyunProperties.getAudit().getImage().getConnectTimeout());
        imageAsyncScanRequest.setSysReadTimeout(aliyunProperties.getAudit().getImage().getReadTimeout());
        log.trace("[Herodotus] |- Bean [Image Async Scan Request] Auto Configure.");
        return imageAsyncScanRequest;
    }

    @Bean
    public ImageAsyncScanResultsRequest imageAsyncSacnResultsRequest(AliyunProperties aliyunProperties) {
        ImageAsyncScanResultsRequest imageAsyncScanResultsRequest = new ImageAsyncScanResultsRequest();
        imageAsyncScanResultsRequest.setSysAcceptFormat(FormatType.JSON);
        imageAsyncScanResultsRequest.setSysMethod(MethodType.POST);
        imageAsyncScanResultsRequest.setSysEncoding(StandardCharsets.UTF_8.name());
        imageAsyncScanResultsRequest.setSysProtocol(ProtocolType.HTTP);
        imageAsyncScanResultsRequest.setSysConnectTimeout(aliyunProperties.getAudit().getImage().getConnectTimeout());
        imageAsyncScanResultsRequest.setSysReadTimeout(aliyunProperties.getAudit().getImage().getReadTimeout());
        log.trace("[Herodotus] |- Bean [Image Async Scan Results Request] Auto Configure.");
        return imageAsyncScanResultsRequest;
    }

    @Bean
    public VideoSyncScanRequest videoSyncScanRequest(AliyunProperties aliyunProperties) {
        VideoSyncScanRequest videoSyncScanRequest = new VideoSyncScanRequest();
        videoSyncScanRequest.setSysAcceptFormat(FormatType.JSON);
        videoSyncScanRequest.setSysMethod(MethodType.POST);
        videoSyncScanRequest.setSysConnectTimeout(aliyunProperties.getAudit().getVideo().getConnectTimeout());
        videoSyncScanRequest.setSysReadTimeout(aliyunProperties.getAudit().getVideo().getReadTimeout());
        log.trace("[Herodotus] |- Bean [Video Sync Scan Request] Auto Configure.");
        return videoSyncScanRequest;
    }

    @Bean
    public VideoAsyncScanRequest videoAsyncScanRequest(AliyunProperties aliyunProperties) {
        VideoAsyncScanRequest videoAsyncScanRequest = new VideoAsyncScanRequest();
        videoAsyncScanRequest.setSysAcceptFormat(FormatType.JSON);
        videoAsyncScanRequest.setSysMethod(MethodType.POST);
        videoAsyncScanRequest.setSysConnectTimeout(aliyunProperties.getAudit().getVideo().getConnectTimeout());
        videoAsyncScanRequest.setSysReadTimeout(aliyunProperties.getAudit().getVideo().getReadTimeout());
        log.trace("[Herodotus] |- Bean [Video Async Scan Request] Auto Configure.");
        return videoAsyncScanRequest;
    }

    @Bean
    public VideoAsyncScanResultsRequest videoAsyncResultRequest(AliyunProperties aliyunProperties) {
        VideoAsyncScanResultsRequest videoAsyncResultRequest = new VideoAsyncScanResultsRequest();
        videoAsyncResultRequest.setSysAcceptFormat(FormatType.JSON);
        videoAsyncResultRequest.setSysConnectTimeout(aliyunProperties.getAudit().getVideo().getConnectTimeout());
        videoAsyncResultRequest.setSysReadTimeout(aliyunProperties.getAudit().getVideo().getReadTimeout());
        log.trace("[Herodotus] |- Bean [Video Async Scan Results Request] Auto Configure.");
        return videoAsyncResultRequest;
    }

    @Bean
    public VoiceSyncScanRequest voiceSyncScanRequest(AliyunProperties aliyunProperties) {
        VoiceSyncScanRequest voiceSyncScanRequest = new VoiceSyncScanRequest();
        voiceSyncScanRequest.setSysAcceptFormat(FormatType.JSON);
        voiceSyncScanRequest.setSysMethod(MethodType.POST);
        voiceSyncScanRequest.setSysRegionId(aliyunProperties.getRegionId());
        voiceSyncScanRequest.setSysConnectTimeout(aliyunProperties.getAudit().getVoice().getConnectTimeout());
        voiceSyncScanRequest.setSysReadTimeout(aliyunProperties.getAudit().getVoice().getReadTimeout());
        log.trace("[Herodotus] |- Bean [Voice Sync Scan Request] Auto Configure.");
        return voiceSyncScanRequest;
    }

    @Bean
    public VoiceAsyncScanRequest voiceAsyncScanRequest(AliyunProperties aliyunProperties) {
        VoiceAsyncScanRequest voiceAsyncScanRequest = new VoiceAsyncScanRequest();
        voiceAsyncScanRequest.setSysAcceptFormat(FormatType.JSON);
        voiceAsyncScanRequest.setSysMethod(MethodType.POST);
        voiceAsyncScanRequest.setSysRegionId(aliyunProperties.getRegionId());
        voiceAsyncScanRequest.setSysConnectTimeout(aliyunProperties.getAudit().getVoice().getConnectTimeout());
        voiceAsyncScanRequest.setSysReadTimeout(aliyunProperties.getAudit().getVoice().getReadTimeout());
        log.trace("[Herodotus] |- Bean [Voice Async Scan Request] Auto Configure.");
        return voiceAsyncScanRequest;
    }

    @Bean
    public VoiceAsyncScanResultsRequest voiceAsyncResultsRequest(AliyunProperties aliyunProperties) {
        VoiceAsyncScanResultsRequest voiceAsyncScanResultsRequest = new VoiceAsyncScanResultsRequest();
        voiceAsyncScanResultsRequest.setSysAcceptFormat(FormatType.JSON);
        voiceAsyncScanResultsRequest.setSysMethod(MethodType.POST);
        voiceAsyncScanResultsRequest.setSysEncoding(StandardCharsets.UTF_8.name());
        voiceAsyncScanResultsRequest.setSysRegionId(aliyunProperties.getRegionId());
        voiceAsyncScanResultsRequest.setSysConnectTimeout(aliyunProperties.getAudit().getVoice().getConnectTimeout());
        voiceAsyncScanResultsRequest.setSysReadTimeout(aliyunProperties.getAudit().getVoice().getReadTimeout());
        log.trace("[Herodotus] |- Bean [Voice Async Scan Results Request] Auto Configure.");
        return voiceAsyncScanResultsRequest;
    }
}

