/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Cloud.
 *
 * Herodotus Cloud is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Cloud is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.openapi.aliyun.audit.properties;

import cn.herodotus.stirrup.openapi.core.constants.OpenApiConstants;
import com.google.common.base.MoreObjects;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * <p>Description: 阿里云通用属性 </p>
 *
 * @author : gengwei.zheng
 * @date : 2021/4/15 11:37
 */
@ConfigurationProperties(prefix = OpenApiConstants.PROPERTY_OPENAPI_ALIYUN)
public class AliyunProperties {

    private String accessKeyId;
    private String accessKeySecret;
    private String regionId;
    /**
     * 用户UID必须是阿里云账号的UID，而不是RAM用户的UID
     * 使用内容检测异步callback方式会用到
     */
    private String uid;
    /**
     * 阿里内容异步检测操作，如果使用callback方式，必须有seed值。
     * <p>
     * 这里配置seed是图方面，最好根据不同的检测任务生成不同的seed，可以放在Redis缓存中。
     */
    private String seed;

    private AliyunAuditProperties audit = new AliyunAuditProperties();

    public String getAccessKeyId() {
        return accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeySecret() {
        return accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public String getRegionId() {
        return regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getSeed() {
        return seed;
    }

    public void setSeed(String seed) {
        this.seed = seed;
    }

    public AliyunAuditProperties getAudit() {
        return audit;
    }

    public void setAudit(AliyunAuditProperties audit) {
        this.audit = audit;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("accessKeyId", accessKeyId)
                .add("accessKeySecret", accessKeySecret)
                .add("regionId", regionId)
                .add("uid", uid)
                .add("seed", seed)
                .add("scan", audit)
                .toString();
    }
}
