/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Cloud.
 *
 * Herodotus Cloud is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Cloud is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.openapi.aliyun.audit.properties;

import com.google.common.base.MoreObjects;

/**
 * <p>Description: 阿里云内容审核配置参数 </p>
 *
 * @author : gengwei.zheng
 * @date : 2021/5/18 18:33
 */
public class AliyunAuditProperties {

    private AliyunTimeoutProperties image = new AliyunTimeoutProperties();
    private AliyunTimeoutProperties video = new AliyunTimeoutProperties();
    private AliyunTimeoutProperties text = new AliyunTimeoutProperties();
    private AliyunTimeoutProperties voice = new AliyunTimeoutProperties();


    public AliyunTimeoutProperties getImage() {
        return image;
    }

    public void setImage(AliyunTimeoutProperties image) {
        this.image = image;
    }

    public AliyunTimeoutProperties getVideo() {
        return video;
    }

    public void setVideo(AliyunTimeoutProperties video) {
        this.video = video;
    }

    public AliyunTimeoutProperties getText() {
        return text;
    }

    public void setText(AliyunTimeoutProperties text) {
        this.text = text;
    }

    public AliyunTimeoutProperties getVoice() {
        return voice;
    }

    public void setVoice(AliyunTimeoutProperties voice) {
        this.voice = voice;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("image", image)
                .add("video", video)
                .add("text", text)
                .add("voice", voice)
                .toString();
    }
}
