/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Cloud.
 *
 * Herodotus Cloud is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Cloud is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.openapi.aliyun.audit.processor;

import cn.herodotus.stirrup.openapi.aliyun.audit.definition.service.AbstractScanChain;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.ScanRequest;
import cn.herodotus.stirrup.openapi.aliyun.audit.service.ImageScanService;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>Description: 图片扫描链 </p>
 *
 * @author : gengwei.zheng
 * @date : 2021/4/23 9:47
 */
@Service
public class ImageScanChain extends AbstractScanChain {

    private static final Logger log = LoggerFactory.getLogger(ImageScanChain.class);

    private final ImageScanService imageScanService;

    private final TextScanChain textScanChain;

    public ImageScanChain(ImageScanService imageScanService, TextScanChain textScanChain) {
        this.imageScanService = imageScanService;
        this.textScanChain = textScanChain;
    }

    @Override
    public boolean execute(ScanRequest scanRequest) {

        List<String> imageUrls = scanRequest.getImageUrls();
        if (CollectionUtils.isNotEmpty(imageUrls)) {
            imageScanService.executeScan(imageUrls);
        }

        return textScanChain.execute(scanRequest);
    }
}
