/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Cloud.
 *
 * Herodotus Cloud is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Cloud is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.openapi.aliyun.audit.domain.video;

import cn.herodotus.stirrup.openapi.aliyun.audit.definition.domain.AbstractFeedbackBody;
import com.google.common.base.MoreObjects;
import io.swagger.v3.oas.annotations.media.Schema;

import java.util.List;

/**
 * <p>Description: 阿里视频检测内容反馈请求参数实体 </p>
 *
 * @author : gengwei.zheng
 * @date : 2021/4/19 14:28
 */
@Schema(title = "阿里视频检测内容反馈请求参数实体")
public class VideoFeedbackBody extends AbstractFeedbackBody {

    /**
     * 用户期望URL的检测结果，传递该参数时必须传递scenes参数。取值范围：
     * pass：正常
     * 说明 反馈pass的图片会流入云盾控制台对应的系统图库。
     * block：违规
     */
    @Schema(title = "用户期望URL的检测结果，传递该参数时必须传递scenes参数", description = "pass：正常, block：违规")
    private String suggestion;

    /**
     * 如果需要将图片样本流入控制台的系统回流库中，则必须传递该参数。
     */
    @Schema(title = "如果需要将图片样本流入控制台的系统回流库中，则必须传递该参数")
    private String url;

    @Schema(title = "指定反馈的场景", description = "porn：智能鉴黄, terrorism：暴恐涉政识别, ad：广告识别")
    private List<String> scenes;

    @Schema(title = "用户认为属于该分类的截帧信息", required = true, description = "frames中的每个元素是个结构体，关于结构的具体描述")
    private List<FeedbackFrame> frames;

    public String getSuggestion() {
        return suggestion;
    }

    public void setSuggestion(String suggestion) {
        this.suggestion = suggestion;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public List<String> getScenes() {
        return scenes;
    }

    public void setScenes(List<String> scenes) {
        this.scenes = scenes;
    }

    public List<FeedbackFrame> getFrames() {
        return frames;
    }

    public void setFrames(List<FeedbackFrame> frames) {
        this.frames = frames;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("suggestion", suggestion)
                .add("url", url)
                .toString();
    }
}
