/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Cloud.
 *
 * Herodotus Cloud is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Cloud is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.openapi.aliyun.audit.domain.image;

import cn.herodotus.stirrup.openapi.aliyun.audit.definition.domain.AbstractFeedbackBody;
import com.google.common.base.MoreObjects;
import io.swagger.v3.oas.annotations.media.Schema;

import java.util.List;

/**
 * <p>Description: 阿里图片检测内容反馈请求参数实体 </p>
 *
 * @author : gengwei.zheng
 * @date : 2021/4/14 11:51
 */
@Schema(title = "阿里图片检测内容反馈请求参数实体")
public class ImageFeedbackBody extends AbstractFeedbackBody {

    /**
     * 用户期望URL的检测结果，传递该参数时必须传递scenes参数。取值范围：
     * pass：正常
     * 说明 反馈pass的图片会流入云盾控制台对应的系统图库。
     * block：违规
     */
    @Schema(title = "用户期望URL的检测结果，传递该参数时必须传递scenes参数", description = "pass：正常, block：违规")
    private String suggestion;

    /**
     * 如果需要将图片样本流入控制台的系统回流库中，则必须传递该参数。
     */
    @Schema(title = "如果需要将图片样本流入控制台的系统回流库中，则必须传递该参数")
    private String url;

    @Schema(title = "指定反馈的场景", description = "porn：智能鉴黄, terrorism：暴恐涉政识别, ad：广告识别")
    private List<String> scenes;

    /**
     * 反馈的分类，与具体的scene对应。关于取值范围的说明，请参见文本反垃圾scene和label说明。
     */
    @Schema(title = "传递该参数表示您认为该图片属于的细分类类别")
    private String label;
    /**
     * 备注。
     */
    @Schema(title = "备注")
    private String note;

    public String getSuggestion() {
        return suggestion;
    }

    public void setSuggestion(String suggestion) {
        this.suggestion = suggestion;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public List<String> getScenes() {
        return scenes;
    }

    public void setScenes(List<String> scenes) {
        this.scenes = scenes;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getNote() {
        return note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("suggestion", suggestion)
                .add("url", url)
                .add("label", label)
                .add("note", note)
                .toString();
    }
}
