/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.openapi.core.definition.converter;

import org.apache.commons.collections4.MapUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>Description: Map<String, Object> 转 Map<String, Object> 转换器</p>
 *
 * @author : gengwei.zheng
 * @date : 2024/2/26 17:04
 */

public class MapToMultiValueMapConverter implements Converter<Map<String, Object>, MultiValueMap<String, String>> {
    @Override
    public MultiValueMap<String, String> convert(Map<String, Object> source) {

        if (MapUtils.isNotEmpty(source)) {

            Map<String, List<String>> temp = source.entrySet()
                    .stream()
                    .collect(Collectors.toMap(Map.Entry::getKey, stringObjectEntry -> List.of(String.valueOf(stringObjectEntry.getValue()))));
            return CollectionUtils.toMultiValueMap(temp);
        }

        return new LinkedMultiValueMap<>();
    }
}
