/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.openapi.core.definition;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>Description: 基础请求参数 </p>
 * <p>
 * 构建参数 Map，方便 OkHttps 使用。
 *
 * @author : gengwei.zheng
 * @date : 2023/4/4 14:18
 */
public abstract class AbstractRequest implements Serializable {

    private final Map<String, Object> params = new HashMap<>();

    protected void put(String key, Object value) {
        this.params.put(key, value);
    }

    public Map<String, Object> getParams() {
        return params;
    }
}
