/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.openapi.core.constants;

import cn.herodotus.stirrup.core.definition.constants.BaseConstants;

/**
 * <p>Description: API 相关模块通用常量 </p>
 *
 * @author : gengwei.zheng
 * @date : 2024/2/23 15:26
 */
public interface OpenApiConstants extends BaseConstants {

    String PROPERTY_OPENAPI_NACOS = PROPERTY_PREFIX_OPENAPI + ".nacos";
    String PROPERTY_OPENAPI_EASEMOB = PROPERTY_PREFIX_OPENAPI + ".easemob";
    String PROPERTY_OPENAPI_EMQX = PROPERTY_PREFIX_OPENAPI + ".emqx";
    String PROPERTY_OPENAPI_POLARIS = PROPERTY_PREFIX_OPENAPI + ".polaris";
    String PROPERTY_OPENAPI_TIANYAN = PROPERTY_PREFIX_OPENAPI + ".tianyan";
    String PROPERTY_OPENAPI_BAIDU = PROPERTY_PREFIX_OPENAPI + ".baidu";
    String PROPERTY_OPENAPI_BAIDU_OCR = PROPERTY_OPENAPI_BAIDU + ".ocr";
    String PROPERTY_OPENAPI_ALIYUN = PROPERTY_PREFIX_OPENAPI + ".aliyun";

    String ITEM_EASEMOB_ENDPOINT = PROPERTY_OPENAPI_NACOS + ".endpoint";
    String ITEM_EASEMOB_CLIENT_ID = PROPERTY_OPENAPI_NACOS + ".client-id";
    String ITEM_EASEMOB_CLIENT_SECRET = PROPERTY_OPENAPI_NACOS + ".client-secret";
    String ITEM_EASEMOB_TOKEN_TTL = PROPERTY_OPENAPI_NACOS + ".token-ttl";
    String ITEM_EMQX_API_KEY = PROPERTY_OPENAPI_EMQX + ".api-key";
    String ITEM_EMQX_SECRET_KEY = PROPERTY_OPENAPI_EMQX + ".secret-key";
    String ITEM_POLARIS_ENDPOINT = PROPERTY_OPENAPI_POLARIS + ".endpoint";
    String ITEM_POLARIS_USERNAME = PROPERTY_OPENAPI_POLARIS + ".username";
    String ITEM_POLARIS_PASSWORD = PROPERTY_OPENAPI_POLARIS + ".password";
    String ITEM_POLARIS_TOKEN_TTL = PROPERTY_OPENAPI_POLARIS + ".token-ttl";
    String ITEM_NACOS_ENDPOINT = PROPERTY_OPENAPI_NACOS + ".endpoint";
    String ITEM_NACOS_USERNAME = PROPERTY_OPENAPI_NACOS + ".username";
    String ITEM_NACOS_PASSWORD = PROPERTY_OPENAPI_NACOS + ".password";
    String ITEM_NACOS_REST_ENABLED = PROPERTY_OPENAPI_NACOS + ".rest-enabled";
    String ITEM_TIANYAN_ENDPOINT = PROPERTY_OPENAPI_TIANYAN + ".endpoint";
    String ITEM_TIANYAN_TOKEN = PROPERTY_OPENAPI_TIANYAN + ".tianyan";
    String ITEM_BAIDU_OCR_APP_ID = PROPERTY_OPENAPI_BAIDU_OCR + ".app-id";
    String ITEM_BAIDU_OCR_APP_KEY = PROPERTY_OPENAPI_BAIDU_OCR + ".app-key";
    String ITEM_BAIDU_OCR_SECRET_KEY = PROPERTY_OPENAPI_BAIDU_OCR + ".secret-key";

    String ITEM_ALIYUN_ACCESS_KEY_ID = PROPERTY_OPENAPI_ALIYUN + ".access-key-id";
    String ITEM_ALIYUN_ACCESS_KEY_SECRET = PROPERTY_OPENAPI_ALIYUN + ".access-key-secret";

}
