/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.openapi.core.definition;

import cn.herodotus.stirrup.core.definition.domain.base.Response;
import cn.herodotus.stirrup.core.foundation.exception.openapi.OpenApiInvokingFailedException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public interface WebClientTemplate {
    public Converter<Map<String, Object>, MultiValueMap<String, String>> getMultiValueMapConverter();

    public WebClient getWebClient();

    public <O> Function<WebClientResponseException, Mono<O>> onErrorResume();

    default public <I, O extends Response> Mono<O> request(HttpMethod httpMethod, String endpoint, I body, Map<String, Object> formVariables, Map<String, Object> pathVariables, Map<String, Object> queryParams, Function<WebClientResponseException, Mono<O>> onErrorResume) {
        WebClient.RequestBodySpec requestBodySpec = ((WebClient.RequestBodySpec)this.getWebClient().method(httpMethod).uri(uriBuilder -> {
            uriBuilder.path(endpoint);
            if (MapUtils.isNotEmpty((Map)queryParams)) {
                uriBuilder.queryParams(Objects.requireNonNull((MultiValueMap)this.getMultiValueMapConverter().convert((Object)queryParams)));
            }
            if (MapUtils.isNotEmpty((Map)pathVariables)) {
                return uriBuilder.build(pathVariables);
            }
            return uriBuilder.build(new Object[0]);
        })).contentType(MapUtils.isNotEmpty(formVariables) ? MediaType.APPLICATION_FORM_URLENCODED : MediaType.APPLICATION_JSON);
        if (MapUtils.isNotEmpty(formVariables)) {
            requestBodySpec.body((BodyInserter)BodyInserters.fromFormData((MultiValueMap)Objects.requireNonNull((MultiValueMap)this.getMultiValueMapConverter().convert(formVariables))));
        }
        if (ObjectUtils.isNotEmpty(body)) {
            requestBodySpec.bodyValue(body);
        }
        return requestBodySpec.retrieve().bodyToMono(new ParameterizedTypeReference<O>(this){}).onErrorResume(throwable -> {
            if (throwable instanceof WebClientResponseException) {
                WebClientResponseException exception = (WebClientResponseException)throwable;
                return (Mono)onErrorResume.apply(exception);
            }
            return Mono.error((Throwable)new OpenApiInvokingFailedException(throwable));
        });
    }

    default public <O extends Response> Mono<O> base(HttpMethod httpMethod, String endpoint, Map<String, Object> pathVariables, Map<String, Object> queryParams) {
        return this.request(httpMethod, endpoint, null, null, pathVariables, queryParams, this.onErrorResume());
    }

    default public <I, O extends Response> Mono<O> json(HttpMethod httpMethod, String endpoint, I body, Map<String, Object> pathVariables) {
        return this.request(httpMethod, endpoint, body, null, pathVariables, null, this.onErrorResume());
    }

    default public <O extends Response> Mono<O> formUrlEncoded(HttpMethod httpMethod, String endpoint, Map<String, Object> formVariables, Map<String, Object> pathVariables) {
        return this.request(httpMethod, endpoint, null, formVariables, pathVariables, null, this.onErrorResume());
    }

    default public <O extends Response> Mono<O> get(String endpoint, Map<String, Object> pathVariables, Map<String, Object> queryParams) {
        return this.base(HttpMethod.GET, endpoint, pathVariables, queryParams);
    }

    default public <O extends Response> Mono<O> get(String endpoint, Map<String, Object> queryParams) {
        return this.get(endpoint, null, queryParams);
    }

    default public <O extends Response> Mono<O> get(String endpoint, String key, String value) {
        return this.get(endpoint, Map.of(key, value));
    }

    default public <O extends Response> Mono<O> get(String endpoint) {
        return this.get(endpoint, null);
    }

    default public <O extends Response> Mono<O> getWithPathVariables(String endpoint, Map<String, Object> pathVariables) {
        return this.get(endpoint, pathVariables, null);
    }

    default public <O extends Response> Mono<O> delete(String endpoint, Map<String, Object> pathVariables, Map<String, Object> queryParams) {
        return this.base(HttpMethod.DELETE, endpoint, pathVariables, queryParams);
    }

    default public <O extends Response> Mono<O> delete(String endpoint, Map<String, Object> queryParams) {
        return this.delete(endpoint, null, queryParams);
    }

    default public <O extends Response> Mono<O> delete(String endpoint) {
        return this.delete(endpoint, null);
    }

    default public <O extends Response> Mono<O> deleteWithPathVariables(String endpoint, Map<String, Object> pathVariables) {
        return this.delete(endpoint, pathVariables, null);
    }

    default public <O extends Response> Mono<O> deleteWithPathVariables(String endpoint, String key, String value) {
        return this.deleteWithPathVariables(endpoint, Map.of(key, value));
    }

    default public <O extends Response> Mono<O> deleteWithFormUrlEncoded(String endpoint, Map<String, Object> formVariables, Map<String, Object> pathVariables) {
        return this.formUrlEncoded(HttpMethod.DELETE, endpoint, formVariables, pathVariables);
    }

    default public <O extends Response> Mono<O> deleteWithFormUrlEncoded(String endpoint, Map<String, Object> formVariables) {
        return this.deleteWithFormUrlEncoded(endpoint, formVariables, null);
    }

    default public <O extends Response> Mono<O> deleteWithFormUrlEncoded(String endpoint, String key, String value) {
        return this.deleteWithFormUrlEncoded(endpoint, Map.of(key, value));
    }

    default public <I, O extends Response> Mono<O> post(String endpoint, I body, Map<String, Object> pathVariables) {
        return this.json(HttpMethod.POST, endpoint, body, pathVariables);
    }

    default public <I, O extends Response> Mono<O> post(String endpoint, I body) {
        return this.post(endpoint, body, null);
    }

    default public <O extends Response> Mono<O> postWithFormUrlEncoded(String endpoint, Map<String, Object> formVariables, Map<String, Object> pathVariables) {
        return this.formUrlEncoded(HttpMethod.POST, endpoint, formVariables, pathVariables);
    }

    default public <O extends Response> Mono<O> postWithFormUrlEncoded(String endpoint, Map<String, Object> formVariables) {
        return this.postWithFormUrlEncoded(endpoint, formVariables, null);
    }

    default public <I, O extends Response> Mono<O> put(String endpoint, I body, Map<String, Object> pathVariables) {
        return this.json(HttpMethod.PUT, endpoint, body, pathVariables);
    }

    default public <I, O extends Response> Mono<O> put(String endpoint, I body) {
        return this.put(endpoint, body, null);
    }

    default public <O extends Response> Mono<O> putWithFormUrlEncoded(String endpoint, Map<String, Object> formVariables, Map<String, Object> pathVariables) {
        return this.formUrlEncoded(HttpMethod.PUT, endpoint, formVariables, pathVariables);
    }

    default public <O extends Response> Mono<O> putWithFormUrlEncoded(String endpoint, Map<String, Object> formVariables) {
        return this.putWithFormUrlEncoded(endpoint, formVariables, null);
    }
}

