/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.openapi.core.definition;

import cn.herodotus.stirrup.core.definition.domain.base.Response;
import cn.herodotus.stirrup.openapi.core.definition.AbstractRequest;
import cn.herodotus.stirrup.openapi.core.definition.WebClientTemplate;
import cn.herodotus.stirrup.openapi.core.definition.converter.MapToMultiValueMapConverter;
import java.util.Map;
import java.util.function.Function;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public abstract class AbstractWebClientTemplate
implements WebClientTemplate {
    private final Converter<Map<String, Object>, MultiValueMap<String, String>> toMultiValueMap;
    private final WebClient webClient;

    public AbstractWebClientTemplate(WebClient webClient) {
        this.webClient = webClient;
        this.toMultiValueMap = new MapToMultiValueMapConverter();
    }

    @Override
    public Converter<Map<String, Object>, MultiValueMap<String, String>> getMultiValueMapConverter() {
        return this.toMultiValueMap;
    }

    @Override
    public WebClient getWebClient() {
        return this.webClient.mutate().baseUrl(this.getBaseUrl()).filter(ExchangeFilterFunction.ofRequestProcessor(this.authentication())).build();
    }

    protected abstract Function<ClientRequest, Mono<ClientRequest>> authentication();

    protected abstract String getBaseUrl();

    public <I extends AbstractRequest, O extends Response> Mono<O> get(String endpoint, I request) {
        return this.get(endpoint, (I)((Object)request.getParams()));
    }

    public <I extends AbstractRequest, O extends Response> Mono<O> delete(String endpoint, I request) {
        return this.delete(endpoint, (I)((Object)request.getParams()));
    }

    public <I extends AbstractRequest, O extends Response> Mono<O> deleteWithFormUrlEncoded(String endpoint, I request) {
        return this.deleteWithFormUrlEncoded(endpoint, (I)((Object)request.getParams()));
    }

    public <I extends AbstractRequest, O extends Response> Mono<O> postWithFormUrlEncoded(String endpoint, I request) {
        return this.postWithFormUrlEncoded(endpoint, (I)((Object)request.getParams()));
    }

    public <I extends AbstractRequest, O extends Response> Mono<O> putWithFormUrlEncoded(String endpoint, I request) {
        return this.putWithFormUrlEncoded(endpoint, (I)((Object)request.getParams()));
    }
}

