/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.management.service;

import cn.herodotus.stirrup.core.definition.domain.base.Entity;
import cn.herodotus.stirrup.data.crud.repository.BaseJpaRepository;
import cn.herodotus.stirrup.data.crud.service.AbstractJpaService;
import cn.herodotus.stirrup.oauth2.management.entity.OAuth2Permission;
import cn.herodotus.stirrup.oauth2.management.entity.OAuth2Scope;
import cn.herodotus.stirrup.oauth2.management.repository.OAuth2ScopeRepository;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class OAuth2ScopeService
extends AbstractJpaService<OAuth2Scope, String> {
    private final OAuth2ScopeRepository oauthScopesRepository;

    public OAuth2ScopeService(OAuth2ScopeRepository oauthScopesRepository) {
        this.oauthScopesRepository = oauthScopesRepository;
    }

    public BaseJpaRepository<OAuth2Scope, String> getRepository() {
        return this.oauthScopesRepository;
    }

    public OAuth2Scope assigned(String scopeId, Set<OAuth2Permission> permissions) {
        OAuth2Scope oldScope = (OAuth2Scope)this.findById((Serializable)((Object)scopeId));
        oldScope.setPermissions(permissions);
        return (OAuth2Scope)this.saveAndFlush((Entity)oldScope);
    }

    public OAuth2Scope findByScopeCode(String scopeCode) {
        return this.oauthScopesRepository.findByScopeCode(scopeCode);
    }

    public List<OAuth2Scope> findByScopeCodeIn(List<String> scopeCodes) {
        return this.oauthScopesRepository.findByScopeCodeIn(scopeCodes);
    }
}

