/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.management.service;

import cn.herodotus.stirrup.core.definition.domain.secure.SecretKey;
import cn.herodotus.stirrup.oauth2.core.servlet.utils.SecurityUtils;
import cn.herodotus.stirrup.web.servlet.crypto.HttpCryptoProcessor;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.stereotype.Service;

@Service
public class InterfaceSecurityService {
    private final HttpCryptoProcessor httpCryptoProcessor;
    private final RegisteredClientRepository registeredClientRepository;

    public InterfaceSecurityService(HttpCryptoProcessor httpCryptoProcessor, RegisteredClientRepository registeredClientRepository) {
        this.httpCryptoProcessor = httpCryptoProcessor;
        this.registeredClientRepository = registeredClientRepository;
    }

    private RegisteredClient validateClient(String clientId, String clientSecret) {
        RegisteredClient registeredClient = this.registeredClientRepository.findByClientId(clientId);
        boolean isMatch = false;
        if (ObjectUtils.isNotEmpty((Object)registeredClient)) {
            isMatch = SecurityUtils.matches((String)clientSecret, (String)registeredClient.getClientSecret());
        }
        if (!isMatch) {
            throw new OAuth2AuthenticationException("invalid_client");
        }
        return registeredClient;
    }

    public SecretKey createSecretKey(String clientId, String clientSecret, String sessionId) {
        RegisteredClient registeredClient = this.validateClient(clientId, clientSecret);
        return this.httpCryptoProcessor.createSecretKey(sessionId, registeredClient.getTokenSettings().getAccessTokenTimeToLive());
    }

    public String exchange(String sessionId, String confidentialBase64) {
        return this.httpCryptoProcessor.exchange(sessionId, confidentialBase64);
    }
}

