/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.management.processor;

import cn.herodotus.stirrup.oauth2.core.definition.domain.HerodotusGrantedAuthority;
import cn.herodotus.stirrup.oauth2.core.definition.service.EnhanceClientDetailsService;
import cn.herodotus.stirrup.oauth2.management.entity.OAuth2Application;
import cn.herodotus.stirrup.oauth2.management.entity.OAuth2Permission;
import cn.herodotus.stirrup.oauth2.management.entity.OAuth2Scope;
import cn.herodotus.stirrup.oauth2.management.service.OAuth2ApplicationService;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class HerodotusClientDetailsService
implements EnhanceClientDetailsService {
    private final OAuth2ApplicationService applicationService;

    public HerodotusClientDetailsService(OAuth2ApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    public Set<HerodotusGrantedAuthority> findAuthoritiesById(String clientId) {
        OAuth2Application application = this.applicationService.findByClientId(clientId);
        if (ObjectUtils.isNotEmpty((Object)((Object)application))) {
            Set<OAuth2Scope> scopes = application.getScopes();
            HashSet<HerodotusGrantedAuthority> result = new HashSet<HerodotusGrantedAuthority>();
            if (CollectionUtils.isNotEmpty(scopes)) {
                for (OAuth2Scope scope : scopes) {
                    Set<OAuth2Permission> permissions = scope.getPermissions();
                    if (!CollectionUtils.isNotEmpty(permissions)) continue;
                    Set grantedAuthorities = permissions.stream().map(item -> new HerodotusGrantedAuthority(item.getPermissionCode())).collect(Collectors.toSet());
                    result.addAll(grantedAuthorities);
                }
            }
            return result;
        }
        return new HashSet<HerodotusGrantedAuthority>();
    }
}

