/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.management.entity;

import cn.herodotus.stirrup.oauth2.management.definition.AbstractOAuth2RegisteredClient;
import cn.herodotus.stirrup.oauth2.management.entity.OAuth2Scope;
import com.google.common.base.MoreObjects;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.UuidGenerator;

@Schema(name="\u7269\u8054\u7f51\u8bbe\u5907")
@Entity
@Table(name="oauth2_device", uniqueConstraints={@UniqueConstraint(columnNames={"device_name"})}, indexes={@Index(name="oauth2_device_id_idx", columnList="device_id"), @Index(name="oauth2_device_ipk_idx", columnList="device_name"), @Index(name="oauth2_device_pid_idx", columnList="product_id")})
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="data:oauth2:device")
public class OAuth2Device
extends AbstractOAuth2RegisteredClient {
    @Schema(name="\u8bbe\u5907ID")
    @Id
    @UuidGenerator
    @Column(name="device_id", length=64)
    private String deviceId;
    @Schema(name="\u8bbe\u5907\u540d\u79f0")
    @Column(name="device_name", length=64, unique=true)
    private String deviceName;
    @Schema(name="\u4ea7\u54c1ID")
    @Column(name="product_id", length=64)
    private String productId;
    @Schema(name="\u662f\u5426\u5df2\u6fc0\u6d3b", title="\u8bbe\u5907\u662f\u5426\u5df2\u7ecf\u6fc0\u6d3b\u72b6\u6001\u6807\u8bb0\uff0c\u9ed8\u8ba4\u503cfalse\uff0c\u5373\u672a\u6fc0\u6d3b")
    @Column(name="is_activated")
    private Boolean activated = Boolean.FALSE;
    @Schema(name="\u8bbe\u5907\u5bf9\u5e94Scope", title="\u4f20\u9012\u8bbe\u5907\u5bf9\u5e94Scope ID\u6570\u7ec4")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="data:oauth2:application:scope")
    @ManyToMany(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SUBSELECT)
    @JoinTable(name="oauth2_device_scope", joinColumns={@JoinColumn(name="device_id")}, inverseJoinColumns={@JoinColumn(name="scope_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"device_id", "scope_id"})}, indexes={@Index(name="oauth2_device_scope_aid_idx", columnList="device_id"), @Index(name="oauth2_device_scope_sid_idx", columnList="scope_id")})
    private Set<OAuth2Scope> scopes = new HashSet<OAuth2Scope>();

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public Boolean getActivated() {
        return this.activated;
    }

    public void setActivated(Boolean activated) {
        this.activated = activated;
    }

    @Override
    public Set<OAuth2Scope> getScopes() {
        return this.scopes;
    }

    public void setScopes(Set<OAuth2Scope> scopes) {
        this.scopes = scopes;
    }

    public String getId() {
        return this.getDeviceId();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("deviceId", (Object)this.deviceId).add("deviceName", (Object)this.deviceName).add("productId", (Object)this.productId).add("activated", (Object)this.activated).toString();
    }
}

