/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.management.entity;

import cn.herodotus.stirrup.oauth2.core.servlet.enums.ApplicationType;
import cn.herodotus.stirrup.oauth2.management.definition.AbstractOAuth2RegisteredClient;
import cn.herodotus.stirrup.oauth2.management.entity.OAuth2Scope;
import com.google.common.base.MoreObjects;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import jakarta.validation.constraints.NotBlank;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.UuidGenerator;

@Schema(name="OAuth2\u5e94\u7528\u5b9e\u4f53")
@Entity
@Table(name="oauth2_application", indexes={@Index(name="oauth2_application_id_idx", columnList="application_id"), @Index(name="oauth2_application_cid_idx", columnList="client_id")})
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="data:oauth2:application")
public class OAuth2Application
extends AbstractOAuth2RegisteredClient {
    @Schema(name="\u5e94\u7528ID")
    @Id
    @UuidGenerator
    @Column(name="application_id", length=64)
    private String applicationId;
    @Schema(name="\u5e94\u7528\u540d\u79f0", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotBlank(message="\u5e94\u7528\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a")
    @Column(name="application_name", length=128)
    private @NotBlank(message="\u5e94\u7528\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") String applicationName;
    @Schema(name="\u5e94\u7528\u7b80\u79f0", title="\u5e94\u7528\u7684\u7b80\u79f0\u3001\u522b\u540d\u3001\u7f29\u5199\u7b49\u4fe1\u606f")
    @Column(name="abbreviation", length=64)
    private String abbreviation;
    @Schema(name="Logo", title="Logo\u5b58\u50a8\u4fe1\u606f\uff0c\u53ef\u4ee5\u662fURL\u6216\u8005\u8def\u5f84\u7b49")
    @Column(name="logo", length=1024)
    private String logo;
    @Schema(name="\u4e3b\u9875\u4fe1\u606f", title="\u5e94\u7528\u76f8\u5173\u7684\u4e3b\u9875\u4fe1\u606f\u65b9\u4fbf\u67e5\u8be2")
    @Column(name="homepage", length=1024)
    private String homepage;
    @Schema(name="\u5e94\u7528\u7c7b\u578b", title="\u7528\u4e8e\u533a\u5206\u4e0d\u540c\u7c7b\u578b\u7684\u5e94\u7528")
    @Column(name="application_type")
    @Enumerated(value=EnumType.ORDINAL)
    private ApplicationType applicationType = ApplicationType.WEB;
    @Schema(name="\u5e94\u7528\u5bf9\u5e94Scope", title="\u4f20\u9012\u5e94\u7528\u5bf9\u5e94Scope ID\u6570\u7ec4")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="data:oauth2:application:scope")
    @ManyToMany(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SUBSELECT)
    @JoinTable(name="oauth2_application_scope", joinColumns={@JoinColumn(name="application_id")}, inverseJoinColumns={@JoinColumn(name="scope_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"application_id", "scope_id"})}, indexes={@Index(name="oauth2_application_scope_aid_idx", columnList="application_id"), @Index(name="oauth2_application_scope_sid_idx", columnList="scope_id")})
    private Set<OAuth2Scope> scopes = new HashSet<OAuth2Scope>();

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(ApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    @Override
    public Set<OAuth2Scope> getScopes() {
        return this.scopes;
    }

    public void setScopes(Set<OAuth2Scope> scopes) {
        this.scopes = scopes;
    }

    public String getId() {
        return this.getApplicationId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        OAuth2Application that = (OAuth2Application)((Object)o);
        return Objects.equals(this.applicationId, that.applicationId);
    }

    public int hashCode() {
        return Objects.hash(this.applicationId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("applicationId", (Object)this.applicationId).add("applicationName", (Object)this.applicationName).add("abbreviation", (Object)this.abbreviation).add("logo", (Object)this.logo).add("homepage", (Object)this.homepage).add("applicationType", (Object)this.applicationType).toString();
    }
}

