/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.management.controller;

import cn.herodotus.stirrup.core.definition.domain.Result;
import cn.herodotus.stirrup.core.definition.domain.base.Entity;
import cn.herodotus.stirrup.data.crud.service.JpaWriteableService;
import cn.herodotus.stirrup.oauth2.management.dto.OAuth2PermissionDto;
import cn.herodotus.stirrup.oauth2.management.dto.OAuth2ScopeDto;
import cn.herodotus.stirrup.oauth2.management.entity.OAuth2Permission;
import cn.herodotus.stirrup.oauth2.management.entity.OAuth2Scope;
import cn.herodotus.stirrup.oauth2.management.service.OAuth2ScopeService;
import cn.herodotus.stirrup.web.core.annotation.AccessLimited;
import cn.herodotus.stirrup.web.servlet.controller.AbstractJpaWriteableController;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/authorize/scope"})
@Tags(value={@Tag(name="OAuth2 \u8ba4\u8bc1\u670d\u52a1\u63a5\u53e3"), @Tag(name="OAuth2 \u6743\u9650\u8303\u56f4\u7ba1\u7406\u63a5\u53e3")})
public class OAuth2ScopeController
extends AbstractJpaWriteableController<OAuth2Scope, String> {
    private final OAuth2ScopeService scopeService;

    @Autowired
    public OAuth2ScopeController(OAuth2ScopeService scopeService) {
        this.scopeService = scopeService;
    }

    public JpaWriteableService<OAuth2Scope, String> getWriteableService() {
        return this.scopeService;
    }

    @Operation(summary="\u7ed9Scope\u5206\u914d\u6743\u9650", description="\u7ed9Scope\u5206\u914d\u6743\u9650", responses={@ApiResponse(description="\u67e5\u8be2\u5230\u7684\u89d2\u8272", content={@Content(mediaType="application/json", schema=@Schema(implementation=OAuth2ScopeDto.class))})})
    @Parameters(value={@Parameter(name="scope", required=true, description="\u8303\u56f4\u8bf7\u6c42\u53c2\u6570")})
    @PostMapping(value={"/assigned"})
    public Result<OAuth2Scope> assigned(@RequestBody OAuth2ScopeDto scope) {
        Set<OAuth2Permission> permissions = new HashSet<OAuth2Permission>();
        if (CollectionUtils.isNotEmpty(scope.getPermissions())) {
            permissions = scope.getPermissions().stream().map(this::toEntity).collect(Collectors.toSet());
        }
        OAuth2Scope result = this.scopeService.assigned(scope.getScopeId(), permissions);
        return this.result((Entity)result);
    }

    @AccessLimited
    @Operation(summary="\u83b7\u53d6\u5168\u90e8\u8303\u56f4", description="\u83b7\u53d6\u5168\u90e8\u8303\u56f4", responses={@ApiResponse(description="\u5168\u90e8\u6570\u636e\u5217\u8868", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))}), @ApiResponse(responseCode="204", description="\u67e5\u8be2\u6210\u529f\uff0c\u672a\u67e5\u5230\u6570\u636e"), @ApiResponse(responseCode="500", description="\u67e5\u8be2\u5931\u8d25")})
    @GetMapping(value={"/list"})
    public Result<List<OAuth2Scope>> findAll() {
        List oAuth2Scopes = this.scopeService.findAll();
        return this.result(oAuth2Scopes);
    }

    @AccessLimited
    @Operation(summary="\u6839\u636e\u8303\u56f4\u4ee3\u7801\u67e5\u8be2\u5e94\u7528\u8303\u56f4", description="\u6839\u636e\u8303\u56f4\u4ee3\u7801\u67e5\u8be2\u5e94\u7528\u8303\u56f4", responses={@ApiResponse(description="\u67e5\u8be2\u5230\u7684\u5e94\u7528\u8303\u56f4", content={@Content(mediaType="application/json", schema=@Schema(implementation=OAuth2Scope.class))}), @ApiResponse(responseCode="204", description="\u67e5\u8be2\u6210\u529f\uff0c\u672a\u67e5\u5230\u6570\u636e"), @ApiResponse(responseCode="500", description="\u67e5\u8be2\u5931\u8d25")})
    @GetMapping(value={"/{scopeCode}"})
    public Result<OAuth2Scope> findByScopeCode(@PathVariable(value="scopeCode") String scopeCode) {
        OAuth2Scope scope = this.scopeService.findByScopeCode(scopeCode);
        return this.result((Entity)scope);
    }

    private OAuth2Permission toEntity(OAuth2PermissionDto dto) {
        OAuth2Permission entity = new OAuth2Permission();
        entity.setPermissionId(dto.getPermissionId());
        entity.setPermissionCode(dto.getPermissionCode());
        entity.setPermissionName(dto.getPermissionName());
        return entity;
    }
}

