/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.management.controller;

import cn.herodotus.stirrup.oauth2.authentication.properties.OAuth2AuthenticationProperties;
import cn.herodotus.stirrup.oauth2.core.servlet.utils.SymmetricUtils;
import cn.herodotus.stirrup.web.servlet.utils.SessionUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.HtmlUtils;

@Controller
public class LoginController {
    private static final String DEFAULT_LOGIN_PAGE_VIEW = "login";
    private static final String DEFAULT_ERROR_PAGE_VIEW = "error";
    private final OAuth2AuthenticationProperties authenticationProperties;

    @Autowired
    public LoginController(OAuth2AuthenticationProperties authenticationProperties) {
        this.authenticationProperties = authenticationProperties;
    }

    @RequestMapping(value={"/login"}, method={RequestMethod.GET})
    public ModelAndView login(Map<String, Object> model, HttpServletRequest request) {
        ModelAndView modelAndView = new ModelAndView(DEFAULT_LOGIN_PAGE_VIEW);
        boolean loginError = this.isErrorPage(request);
        boolean logoutSuccess = this.isLogoutSuccess(request);
        String errorMessage = this.getErrorMessage(request);
        Map<String, String> hiddenInputs = this.hiddenInputs(request);
        modelAndView.addObject("vulgar_tycoon", (Object)this.getFormLogin().getUsernameParameter());
        modelAndView.addObject("beast", (Object)this.getFormLogin().getPasswordParameter());
        modelAndView.addObject("anubis", (Object)this.getFormLogin().getRememberMeParameter());
        modelAndView.addObject("graphic", (Object)this.getFormLogin().getCaptchaParameter());
        modelAndView.addObject("hide_verification_code", (Object)this.getFormLogin().getCloseCaptcha());
        modelAndView.addObject("soup_spoon", (Object)SymmetricUtils.getEncryptedSymmetricKey());
        modelAndView.addObject("verification_category", (Object)this.getFormLogin().getCategory());
        modelAndView.addObject("hidden_inputs", hiddenInputs);
        modelAndView.addObject("login_error", (Object)loginError);
        modelAndView.addObject("logout_success", (Object)logoutSuccess);
        modelAndView.addObject("message", (Object)(StringUtils.isNotBlank((CharSequence)errorMessage) ? HtmlUtils.htmlEscape((String)errorMessage) : null));
        modelAndView.addObject("contentPath", (Object)request.getContextPath());
        modelAndView.addObject("sessionId", (Object)SessionUtils.analyseSessionId((HttpServletRequest)request));
        return modelAndView;
    }

    private OAuth2AuthenticationProperties.FormLogin getFormLogin() {
        return this.authenticationProperties.getFormLogin();
    }

    private boolean isErrorPage(HttpServletRequest request) {
        String failureUrl = "login?error";
        return this.matches(request, failureUrl);
    }

    private boolean isLogoutSuccess(HttpServletRequest request) {
        String logoutSuccessUrl = "login?logout";
        return this.matches(request, logoutSuccessUrl);
    }

    private Map<String, String> hiddenInputs(HttpServletRequest request) {
        CsrfToken token = (CsrfToken)request.getAttribute(CsrfToken.class.getName());
        return token != null ? Collections.singletonMap(token.getParameterName(), token.getToken()) : Collections.emptyMap();
    }

    private String getErrorMessage(HttpServletRequest request) {
        String message;
        HttpSession session = SessionUtils.getSession((HttpServletRequest)request);
        if (ObjectUtils.isNotEmpty((Object)session) && ObjectUtils.isNotEmpty((Object)(message = (String)session.getAttribute("SPRING_SECURITY_LAST_EXCEPTION")))) {
            return message;
        }
        return null;
    }

    private boolean matches(HttpServletRequest request, String url) {
        if (!HttpMethod.GET.name().equals(request.getMethod()) || url == null) {
            return false;
        }
        Object uri = request.getRequestURI();
        int pathParamIndex = ((String)uri).indexOf(59);
        if (pathParamIndex > 0) {
            uri = ((String)uri).substring(0, pathParamIndex);
        }
        if (request.getQueryString() != null) {
            uri = (String)uri + "?" + request.getQueryString();
        }
        if ("".equals(request.getContextPath())) {
            return ((String)uri).equals(url);
        }
        return ((String)uri).equals(request.getContextPath() + url);
    }
}

