/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.management.compliance;

import cn.herodotus.stirrup.data.core.enums.DataItemStatus;
import cn.herodotus.stirrup.message.ability.definition.AccountStatusEventManager;
import cn.herodotus.stirrup.message.ability.domain.UserStatus;
import cn.herodotus.stirrup.oauth2.authentication.stamp.LockedUserDetailsStampManager;
import cn.herodotus.stirrup.oauth2.core.definition.domain.HerodotusUser;
import cn.herodotus.stirrup.oauth2.core.definition.service.EnhanceUserDetailsService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Service;

@Service
public class OAuth2AccountStatusManager {
    private static final Logger log = LoggerFactory.getLogger(OAuth2AccountStatusManager.class);
    private final UserDetailsService userDetailsService;
    private final AccountStatusEventManager accountStatusEventManager;
    private final LockedUserDetailsStampManager lockedUserDetailsStampManager;

    public OAuth2AccountStatusManager(UserDetailsService userDetailsService, AccountStatusEventManager accountStatusEventManager, LockedUserDetailsStampManager lockedUserDetailsStampManager) {
        this.userDetailsService = userDetailsService;
        this.lockedUserDetailsStampManager = lockedUserDetailsStampManager;
        this.accountStatusEventManager = accountStatusEventManager;
    }

    private EnhanceUserDetailsService getUserDetailsService() {
        return (EnhanceUserDetailsService)this.userDetailsService;
    }

    private String getUserId(String username) {
        EnhanceUserDetailsService enhanceUserDetailsService = this.getUserDetailsService();
        HerodotusUser user = enhanceUserDetailsService.loadHerodotusUserByUsername(username);
        if (ObjectUtils.isNotEmpty((Object)user)) {
            return user.getUserId();
        }
        log.warn("[Herodotus] |- Can not found the userid for [{}]", (Object)username);
        return null;
    }

    public void lock(String username) {
        String userId = this.getUserId(username);
        if (ObjectUtils.isNotEmpty((Object)userId)) {
            this.accountStatusEventManager.postProcess((Object)new UserStatus(userId, DataItemStatus.LOCKING.name()));
            this.lockedUserDetailsStampManager.put((Object)userId, (Object)username);
            log.info("[Herodotus] |- User count [{}] has been locked, and record into cache!", (Object)username);
        }
    }

    public void enable(String userId) {
        if (ObjectUtils.isNotEmpty((Object)userId)) {
            this.accountStatusEventManager.postProcess((Object)new UserStatus(userId, DataItemStatus.ENABLE.name()));
        }
    }

    public void releaseFromCache(String username) {
        String value;
        String userId = this.getUserId(username);
        if (ObjectUtils.isNotEmpty((Object)userId) && StringUtils.isNotEmpty((CharSequence)(value = (String)this.lockedUserDetailsStampManager.get((Object)userId)))) {
            this.lockedUserDetailsStampManager.delete((Object)userId);
            log.info("[Herodotus] |- User count [{}] locked info has been release!", (Object)username);
        }
    }
}

