/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.data.jpa.service;

import cn.herodotus.stirrup.data.crud.repository.BaseJpaRepository;
import cn.herodotus.stirrup.data.crud.service.AbstractJpaService;
import cn.herodotus.stirrup.oauth2.data.jpa.entity.HerodotusAuthorizationConsent;
import cn.herodotus.stirrup.oauth2.data.jpa.generator.HerodotusAuthorizationConsentId;
import cn.herodotus.stirrup.oauth2.data.jpa.repository.HerodotusAuthorizationConsentRepository;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HerodotusAuthorizationConsentService
extends AbstractJpaService<HerodotusAuthorizationConsent, HerodotusAuthorizationConsentId> {
    private static final Logger log = LoggerFactory.getLogger(HerodotusAuthorizationConsentService.class);
    private final HerodotusAuthorizationConsentRepository authorizationConsentRepository;

    @Autowired
    public HerodotusAuthorizationConsentService(HerodotusAuthorizationConsentRepository authorizationConsentRepository) {
        this.authorizationConsentRepository = authorizationConsentRepository;
    }

    public BaseJpaRepository<HerodotusAuthorizationConsent, HerodotusAuthorizationConsentId> getRepository() {
        return this.authorizationConsentRepository;
    }

    public Optional<HerodotusAuthorizationConsent> findByRegisteredClientIdAndPrincipalName(String registeredClientId, String principalName) {
        Optional<HerodotusAuthorizationConsent> result = this.authorizationConsentRepository.findByRegisteredClientIdAndPrincipalName(registeredClientId, principalName);
        log.trace("[Herodotus] |- HerodotusAuthorizationConsent Service findByRegisteredClientIdAndPrincipalName.");
        return result;
    }

    public void deleteByRegisteredClientIdAndPrincipalName(String registeredClientId, String principalName) {
        this.authorizationConsentRepository.deleteByRegisteredClientIdAndPrincipalName(registeredClientId, principalName);
        log.trace("[Herodotus] |- HerodotusAuthorizationConsent Service deleteByRegisteredClientIdAndPrincipalName.");
    }
}

