/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.data.jpa.converter;

import cn.herodotus.stirrup.oauth2.core.utils.OAuth2AuthorizationUtils;
import cn.herodotus.stirrup.oauth2.data.jpa.definition.converter.AbstractOAuth2EntityConverter;
import cn.herodotus.stirrup.oauth2.data.jpa.entity.HerodotusAuthorization;
import cn.herodotus.stirrup.oauth2.data.jpa.processor.OAuth2JacksonProcessor;
import java.time.temporal.TemporalAccessor;
import org.dromara.hutool.core.date.DateUtil;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2DeviceCode;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.core.OAuth2UserCode;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationCode;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.util.StringUtils;

public class HerodotusToOAuth2AuthorizationConverter
extends AbstractOAuth2EntityConverter<HerodotusAuthorization, OAuth2Authorization> {
    private final RegisteredClientRepository registeredClientRepository;

    public HerodotusToOAuth2AuthorizationConverter(OAuth2JacksonProcessor jacksonProcessor, RegisteredClientRepository registeredClientRepository) {
        super(jacksonProcessor);
        this.registeredClientRepository = registeredClientRepository;
    }

    public OAuth2Authorization convert(HerodotusAuthorization entity) {
        RegisteredClient registeredClient = this.registeredClientRepository.findById(entity.getRegisteredClientId());
        if (registeredClient == null) {
            throw new DataRetrievalFailureException("The RegisteredClient with id '" + entity.getRegisteredClientId() + "' was not found in the RegisteredClientRepository.");
        }
        OAuth2Authorization.Builder builder = OAuth2Authorization.withRegisteredClient((RegisteredClient)registeredClient).id(entity.getId()).principalName(entity.getPrincipalName()).authorizationGrantType(OAuth2AuthorizationUtils.resolveAuthorizationGrantType((String)entity.getAuthorizationGrantType())).authorizedScopes(StringUtils.commaDelimitedListToSet((String)entity.getAuthorizedScopes())).attributes(attributes -> attributes.putAll(this.parseMap(entity.getAttributes())));
        if (entity.getState() != null) {
            builder.attribute("state", (Object)entity.getState());
        }
        if (entity.getAuthorizationCodeValue() != null) {
            OAuth2AuthorizationCode authorizationCode = new OAuth2AuthorizationCode(entity.getAuthorizationCodeValue(), DateUtil.toInstant((TemporalAccessor)entity.getAuthorizationCodeIssuedAt()), DateUtil.toInstant((TemporalAccessor)entity.getAuthorizationCodeExpiresAt()));
            builder.token((OAuth2Token)authorizationCode, metadata -> metadata.putAll(this.parseMap(entity.getAuthorizationCodeMetadata())));
        }
        if (entity.getAccessTokenValue() != null) {
            OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, entity.getAccessTokenValue(), DateUtil.toInstant((TemporalAccessor)entity.getAccessTokenIssuedAt()), DateUtil.toInstant((TemporalAccessor)entity.getAccessTokenExpiresAt()), StringUtils.commaDelimitedListToSet((String)entity.getAccessTokenScopes()));
            builder.token((OAuth2Token)accessToken, metadata -> metadata.putAll(this.parseMap(entity.getAccessTokenMetadata())));
        }
        if (entity.getRefreshTokenValue() != null) {
            OAuth2RefreshToken refreshToken = new OAuth2RefreshToken(entity.getRefreshTokenValue(), DateUtil.toInstant((TemporalAccessor)entity.getRefreshTokenIssuedAt()), DateUtil.toInstant((TemporalAccessor)entity.getRefreshTokenExpiresAt()));
            builder.token((OAuth2Token)refreshToken, metadata -> metadata.putAll(this.parseMap(entity.getRefreshTokenMetadata())));
        }
        if (entity.getOidcIdTokenValue() != null) {
            OidcIdToken idToken = new OidcIdToken(entity.getOidcIdTokenValue(), DateUtil.toInstant((TemporalAccessor)entity.getOidcIdTokenIssuedAt()), DateUtil.toInstant((TemporalAccessor)entity.getOidcIdTokenExpiresAt()), this.parseMap(entity.getOidcIdTokenClaims()));
            builder.token((OAuth2Token)idToken, metadata -> metadata.putAll(this.parseMap(entity.getOidcIdTokenMetadata())));
        }
        if (entity.getUserCodeValue() != null) {
            OAuth2UserCode userCode = new OAuth2UserCode(entity.getUserCodeValue(), DateUtil.toInstant((TemporalAccessor)entity.getUserCodeIssuedAt()), DateUtil.toInstant((TemporalAccessor)entity.getUserCodeExpiresAt()));
            builder.token((OAuth2Token)userCode, metadata -> metadata.putAll(this.parseMap(entity.getUserCodeMetadata())));
        }
        if (entity.getDeviceCodeValue() != null) {
            OAuth2DeviceCode deviceCode = new OAuth2DeviceCode(entity.getDeviceCodeValue(), DateUtil.toInstant((TemporalAccessor)entity.getDeviceCodeIssuedAt()), DateUtil.toInstant((TemporalAccessor)entity.getDeviceCodeExpiresAt()));
            builder.token((OAuth2Token)deviceCode, metadata -> metadata.putAll(this.parseMap(entity.getDeviceCodeMetadata())));
        }
        return builder.build();
    }
}

