/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.data.jpa.converter;

import cn.herodotus.stirrup.oauth2.core.definition.domain.HerodotusGrantedAuthority;
import cn.herodotus.stirrup.oauth2.data.jpa.entity.HerodotusAuthorizationConsent;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsent;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.util.StringUtils;

public class HerodotusToOAuth2AuthorizationConsentConverter
implements Converter<HerodotusAuthorizationConsent, OAuth2AuthorizationConsent> {
    private final RegisteredClientRepository registeredClientRepository;

    public HerodotusToOAuth2AuthorizationConsentConverter(RegisteredClientRepository registeredClientRepository) {
        this.registeredClientRepository = registeredClientRepository;
    }

    public OAuth2AuthorizationConsent convert(HerodotusAuthorizationConsent authorizationConsent) {
        String registeredClientId = authorizationConsent.getRegisteredClientId();
        RegisteredClient registeredClient = this.registeredClientRepository.findById(registeredClientId);
        if (registeredClient == null) {
            throw new DataRetrievalFailureException("The RegisteredClient with id '" + registeredClientId + "' was not found in the RegisteredClientRepository.");
        }
        OAuth2AuthorizationConsent.Builder builder = OAuth2AuthorizationConsent.withId((String)registeredClientId, (String)authorizationConsent.getPrincipalName());
        if (authorizationConsent.getAuthorities() != null) {
            for (String authority : StringUtils.commaDelimitedListToSet((String)authorizationConsent.getAuthorities())) {
                builder.authority((GrantedAuthority)new HerodotusGrantedAuthority(authority));
            }
        }
        return builder.build();
    }
}

