/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authorization.servlet;

import cn.herodotus.stirrup.core.autoconfigure.oauth2.properties.OAuth2AuthorizationProperties;
import cn.herodotus.stirrup.core.foundation.enums.Target;
import cn.herodotus.stirrup.oauth2.authorization.servlet.HerodotusAccessDeniedHandler;
import cn.herodotus.stirrup.oauth2.authorization.servlet.HerodotusAuthenticationEntryPoint;
import cn.herodotus.stirrup.oauth2.authorization.servlet.HerodotusJwtAuthenticationConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.security.oauth2.server.resource.web.DefaultBearerTokenResolver;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;

public class OAuth2ResourceServerConfigurerCustomer
implements Customizer<OAuth2ResourceServerConfigurer<HttpSecurity>> {
    private final JwtDecoder jwtDecoder;
    private final OAuth2AuthorizationProperties authorizationProperties;
    private final OpaqueTokenIntrospector opaqueTokenIntrospector;

    public OAuth2ResourceServerConfigurerCustomer(OAuth2AuthorizationProperties authorizationProperties, JwtDecoder jwtDecoder, OpaqueTokenIntrospector opaqueTokenIntrospector) {
        this.jwtDecoder = jwtDecoder;
        this.authorizationProperties = authorizationProperties;
        this.opaqueTokenIntrospector = opaqueTokenIntrospector;
    }

    private boolean isRemoteValidate() {
        return this.authorizationProperties.getValidate() == Target.REMOTE;
    }

    public void customize(OAuth2ResourceServerConfigurer<HttpSecurity> configurer) {
        if (this.isRemoteValidate()) {
            configurer.opaqueToken(opaque -> opaque.introspector(this.opaqueTokenIntrospector));
        } else {
            configurer.jwt(jwt -> jwt.decoder(this.jwtDecoder).jwtAuthenticationConverter((Converter)new HerodotusJwtAuthenticationConverter())).bearerTokenResolver((BearerTokenResolver)new DefaultBearerTokenResolver());
        }
        configurer.accessDeniedHandler((AccessDeniedHandler)new HerodotusAccessDeniedHandler()).authenticationEntryPoint((AuthenticationEntryPoint)new HerodotusAuthenticationEntryPoint());
    }
}

