/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authorization.reactive;

import cn.herodotus.stirrup.core.autoconfigure.oauth2.domain.HerodotusRequest;
import cn.herodotus.stirrup.core.autoconfigure.oauth2.reactive.ReactiveOAuth2ResourceMatcherConfigurer;
import cn.herodotus.stirrup.core.identity.domain.HerodotusSecurityAttribute;
import cn.herodotus.stirrup.oauth2.authorization.processor.SecurityAttributeStorage;
import cn.herodotus.stirrup.oauth2.authorization.reactive.ReactiveExpressionAuthorizationManager;
import cn.herodotus.stirrup.web.core.reactive.utils.ExchangeUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.security.authorization.AuthenticatedReactiveAuthorizationManager;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.server.authorization.AuthorizationContext;
import org.springframework.security.web.server.util.matcher.PathPatternParserServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveSecurityAuthorizationManager
implements ReactiveAuthorizationManager<AuthorizationContext> {
    private static final Logger log = LoggerFactory.getLogger(ReactiveSecurityAuthorizationManager.class);
    private final SecurityAttributeStorage securityAttributeStorage;
    private final ReactiveOAuth2ResourceMatcherConfigurer reactiveOAuth2ResourceMatcherConfigurer;

    public ReactiveSecurityAuthorizationManager(SecurityAttributeStorage securityAttributeStorage, ReactiveOAuth2ResourceMatcherConfigurer reactiveOAuth2ResourceMatcherConfigurer) {
        this.securityAttributeStorage = securityAttributeStorage;
        this.reactiveOAuth2ResourceMatcherConfigurer = reactiveOAuth2ResourceMatcherConfigurer;
    }

    public Mono<AuthorizationDecision> check(Mono<Authentication> authentication, AuthorizationContext object) {
        ServerWebExchange exchange = object.getExchange();
        String uri = ExchangeUtils.getRequestPath((ServerWebExchange)exchange);
        HttpMethod httpMethod = ExchangeUtils.getHttpMethod((ServerWebExchange)exchange);
        if (this.reactiveOAuth2ResourceMatcherConfigurer.isPermitAllRequest(uri)) {
            log.trace("[Herodotus] |- Is white list resource : [{}], Passed!", (Object)uri);
            return this.isGranted(true);
        }
        if (this.reactiveOAuth2ResourceMatcherConfigurer.isHasAuthenticatedRequest(uri)) {
            log.trace("[Herodotus] |- Is has authenticated resource : [{}]", (Object)uri);
            return this.isAuthenticated(authentication, object);
        }
        List<HerodotusSecurityAttribute> configAttributes = this.findConfigAttribute(uri, httpMethod, exchange);
        if (CollectionUtils.isEmpty(configAttributes)) {
            log.warn("[Herodotus] |- NO PRIVILEGES : [{}].", (Object)uri);
            if (!this.reactiveOAuth2ResourceMatcherConfigurer.isStrictMode()) {
                return this.isAuthenticated(authentication, object);
            }
            return this.isGranted(false);
        }
        return Flux.fromIterable(configAttributes).flatMap(item -> ReactiveExpressionAuthorizationManager.expression().check(authentication, (HerodotusSecurityAttribute)item)).filter(AuthorizationDecision::isGranted).hasElements().flatMap(this::isGranted);
    }

    private Mono<AuthorizationDecision> isGranted(boolean granted) {
        return Mono.just((Object)new AuthorizationDecision(granted));
    }

    private Mono<AuthorizationDecision> isAuthenticated(Mono<Authentication> authentication, AuthorizationContext object) {
        return AuthenticatedReactiveAuthorizationManager.authenticated().check(authentication, (Object)object);
    }

    private List<HerodotusSecurityAttribute> findConfigAttribute(String url, HttpMethod method, ServerWebExchange serverWebExchange) {
        log.debug("[Herodotus] |- Current Request is : [{}] - [{}]", (Object)url, (Object)method);
        List<HerodotusSecurityAttribute> configAttributes = this.securityAttributeStorage.getConfigAttribute(url, method.name());
        if (CollectionUtils.isNotEmpty(configAttributes)) {
            log.debug("[Herodotus] |- Get configAttributes from local storage for : [{}] - [{}]", (Object)url, (Object)method.name());
            return configAttributes;
        }
        Map<HerodotusRequest, List<HerodotusSecurityAttribute>> compatible = this.securityAttributeStorage.getCompatible();
        if (MapUtils.isNotEmpty(compatible)) {
            for (Map.Entry<HerodotusRequest, List<HerodotusSecurityAttribute>> entry : compatible.entrySet()) {
                PathPatternParserServerWebExchangeMatcher matcher = this.toMatcher(entry.getKey());
                Mono result = matcher.matches(serverWebExchange);
                Optional optional = result.blockOptional();
                if (!optional.isPresent() || !((ServerWebExchangeMatcher.MatchResult)optional.get()).isMatch()) continue;
                log.debug("[Herodotus] |- Request match the wildcard [{}] - [{}]", (Object)entry.getKey(), entry.getValue());
                return entry.getValue();
            }
        }
        return null;
    }

    private PathPatternParserServerWebExchangeMatcher toMatcher(HerodotusRequest herodotusRequest) {
        HttpMethod httpMethod = null;
        if (StringUtils.isNotBlank((CharSequence)herodotusRequest.getHttpMethod())) {
            httpMethod = HttpMethod.valueOf((String)herodotusRequest.getHttpMethod());
        }
        return new PathPatternParserServerWebExchangeMatcher(herodotusRequest.getPattern(), httpMethod);
    }
}

