/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authorization.reactive;

import cn.herodotus.stirrup.core.identity.domain.HerodotusSecurityAttribute;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.core.Authentication;
import reactor.core.publisher.Mono;

public class ReactiveExpressionAuthorizationManager
implements ReactiveAuthorizationManager<HerodotusSecurityAttribute> {
    private final MethodSecurityExpressionHandler expressionHandler;

    public ReactiveExpressionAuthorizationManager() {
        this((MethodSecurityExpressionHandler)new DefaultMethodSecurityExpressionHandler());
    }

    public ReactiveExpressionAuthorizationManager(MethodSecurityExpressionHandler expressionHandler) {
        this.expressionHandler = expressionHandler;
    }

    public Mono<AuthorizationDecision> check(Mono<Authentication> authentication, HerodotusSecurityAttribute attribute) {
        Expression expression = this.expressionHandler.getExpressionParser().parseExpression(attribute.getExpression());
        return authentication.map(auth -> this.expressionHandler.createEvaluationContext(auth, (Object)HerodotusSecurityAttribute.createMethodInvocation((HerodotusSecurityAttribute)attribute))).flatMap(ctx -> ReactiveExpressionAuthorizationManager.evaluateAsBoolean(expression, ctx)).map(AuthorizationDecision::new);
    }

    public static ReactiveExpressionAuthorizationManager expression() {
        return new ReactiveExpressionAuthorizationManager();
    }

    private static Mono<Boolean> evaluateAsBoolean(Expression expr, EvaluationContext ctx) {
        return Mono.defer(() -> {
            Object value;
            try {
                value = expr.getValue(ctx);
            }
            catch (EvaluationException ex) {
                return Mono.error(() -> new IllegalArgumentException("Failed to evaluate expression '" + expr.getExpressionString() + "'", ex));
            }
            if (value instanceof Boolean) {
                return Mono.just((Object)((Boolean)value));
            }
            if (value instanceof Mono) {
                Mono monoValue = (Mono)value;
                return monoValue.filter(Boolean.class::isInstance).map(Boolean.class::cast).switchIfEmpty(ReactiveExpressionAuthorizationManager.createInvalidReturnTypeMono(expr));
            }
            return ReactiveExpressionAuthorizationManager.createInvalidReturnTypeMono(expr);
        });
    }

    private static Mono<Boolean> createInvalidReturnTypeMono(Expression expr) {
        return Mono.error(() -> new IllegalStateException("Expression: '" + expr.getExpressionString() + "' must return boolean or Mono<Boolean>"));
    }
}

