/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authorization.config;

import cn.herodotus.stirrup.core.autoconfigure.oauth2.properties.OAuth2AuthorizationProperties;
import cn.herodotus.stirrup.core.autoconfigure.oauth2.servlet.ServletOAuth2ResourceMatcherConfigurer;
import cn.herodotus.stirrup.core.foundation.annotation.ConditionalOnServletApplication;
import cn.herodotus.stirrup.oauth2.authorization.config.OAuth2ServletSessionConfiguration;
import cn.herodotus.stirrup.oauth2.authorization.processor.SecurityAttributeAnalyzer;
import cn.herodotus.stirrup.oauth2.authorization.processor.SecurityAttributeStorage;
import cn.herodotus.stirrup.oauth2.authorization.servlet.OAuth2AuthorizeHttpRequestsConfigurerCustomer;
import cn.herodotus.stirrup.oauth2.authorization.servlet.OAuth2ResourceServerConfigurerCustomer;
import cn.herodotus.stirrup.oauth2.authorization.servlet.ServletSecurityAuthorizationManager;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;

@Configuration(proxyBeanMethods=false)
@ConditionalOnServletApplication
@EnableMethodSecurity(proxyTargetClass=true, securedEnabled=true, jsr250Enabled=true)
@Import(value={OAuth2ServletSessionConfiguration.class})
public class OAuth2AuthorizationServletConfiguration {
    private static final Logger log = LoggerFactory.getLogger(OAuth2AuthorizationServletConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- Module [OAuth2 Authorization Servlet] Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public SecurityAttributeStorage securityMetadataSourceStorage() {
        SecurityAttributeStorage storage = new SecurityAttributeStorage();
        log.trace("[Herodotus] |- Bean [Security Metadata Source Storage] Configure.");
        return storage;
    }

    @Bean
    @ConditionalOnMissingBean
    public ServletSecurityAuthorizationManager servletSecurityAuthorizationManager(SecurityAttributeStorage securityAttributeStorage, ServletOAuth2ResourceMatcherConfigurer servletOAuth2ResourceMatcherConfigurer) {
        ServletSecurityAuthorizationManager manager = new ServletSecurityAuthorizationManager(securityAttributeStorage, servletOAuth2ResourceMatcherConfigurer);
        log.trace("[Herodotus] |- Bean [Servlet Security Authorization Manager] Configure.");
        return manager;
    }

    @Bean
    @ConditionalOnMissingBean
    public OAuth2AuthorizeHttpRequestsConfigurerCustomer oauth2AuthorizeHttpRequestsConfigurerCustomer(ServletOAuth2ResourceMatcherConfigurer servletOAuth2ResourceMatcherConfigurer, ServletSecurityAuthorizationManager servletSecurityAuthorizationManager) {
        OAuth2AuthorizeHttpRequestsConfigurerCustomer customer = new OAuth2AuthorizeHttpRequestsConfigurerCustomer(servletOAuth2ResourceMatcherConfigurer, servletSecurityAuthorizationManager);
        log.trace("[Herodotus] |- Bean [OAuth2 Authorize Http Requests Configurer Customer] Configure.");
        return customer;
    }

    @Bean
    @ConditionalOnMissingBean
    public OAuth2ResourceServerConfigurerCustomer oauth2ResourceServerConfigurerCustomer(OAuth2AuthorizationProperties authorizationProperties, JwtDecoder jwtDecoder, OpaqueTokenIntrospector opaqueTokenIntrospector) {
        OAuth2ResourceServerConfigurerCustomer customer = new OAuth2ResourceServerConfigurerCustomer(authorizationProperties, jwtDecoder, opaqueTokenIntrospector);
        log.trace("[Herodotus] |- Bean [OAuth2 Resource Server Configurer Customer] Configure.");
        return customer;
    }

    @Bean
    @ConditionalOnMissingBean
    public SecurityAttributeAnalyzer securityAttributeAnalyzer(SecurityAttributeStorage securityAttributeStorage, ServletOAuth2ResourceMatcherConfigurer servletOAuth2ResourceMatcherConfigurer) {
        SecurityAttributeAnalyzer analyzer = new SecurityAttributeAnalyzer(securityAttributeStorage, servletOAuth2ResourceMatcherConfigurer.getPermitAllAttributes());
        log.trace("[Herodotus] |- Bean [Security Attribute Analyzer] Configure.");
        return analyzer;
    }
}

