/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authorization.config;

import cn.herodotus.stirrup.core.autoconfigure.oauth2.properties.OAuth2AuthorizationProperties;
import cn.herodotus.stirrup.core.autoconfigure.oauth2.reactive.ReactiveOAuth2ResourceMatcherConfigurer;
import cn.herodotus.stirrup.core.foundation.annotation.ConditionalOnReactiveApplication;
import cn.herodotus.stirrup.oauth2.authorization.processor.SecurityAttributeAnalyzer;
import cn.herodotus.stirrup.oauth2.authorization.processor.SecurityAttributeStorage;
import cn.herodotus.stirrup.oauth2.authorization.reactive.OAuth2AuthorizeExchangeSpecCustomizer;
import cn.herodotus.stirrup.oauth2.authorization.reactive.OAuth2ResourceServerSpecCustomizer;
import cn.herodotus.stirrup.oauth2.authorization.reactive.ReactiveSecurityAuthorizationManager;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.method.configuration.EnableReactiveMethodSecurity;
import org.springframework.security.oauth2.server.resource.introspection.ReactiveOpaqueTokenIntrospector;

@Configuration(proxyBeanMethods=false)
@ConditionalOnReactiveApplication
@EnableReactiveMethodSecurity
public class OAuth2AuthorizationReactiveConfiguration {
    private static final Logger log = LoggerFactory.getLogger(OAuth2AuthorizationReactiveConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- Module [OAuth2 Authorization Reactive] Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public SecurityAttributeStorage securityAttributeStorage() {
        SecurityAttributeStorage securityAttributeStorage = new SecurityAttributeStorage();
        log.trace("[Herodotus] |- Bean [Security Attribute Storage] Configure.");
        return securityAttributeStorage;
    }

    @Bean
    @ConditionalOnMissingBean
    public ReactiveSecurityAuthorizationManager reactiveSecurityAuthorizationManager(SecurityAttributeStorage securityAttributeStorage, ReactiveOAuth2ResourceMatcherConfigurer reactiveOAuth2ResourceMatcherConfigurer) {
        ReactiveSecurityAuthorizationManager manager = new ReactiveSecurityAuthorizationManager(securityAttributeStorage, reactiveOAuth2ResourceMatcherConfigurer);
        log.trace("[Herodotus] |- Bean [Reactive Security Authorization Manager] Configure.");
        return manager;
    }

    @Bean
    @ConditionalOnMissingBean
    public OAuth2AuthorizeExchangeSpecCustomizer oauth2AuthorizeExchangeSpecCustomizer(ReactiveOAuth2ResourceMatcherConfigurer reactiveOAuth2ResourceMatcherConfigurer, ReactiveSecurityAuthorizationManager reactiveSecurityAuthorizationManager) {
        OAuth2AuthorizeExchangeSpecCustomizer customizer = new OAuth2AuthorizeExchangeSpecCustomizer(reactiveOAuth2ResourceMatcherConfigurer, reactiveSecurityAuthorizationManager);
        log.trace("[Herodotus] |- Bean [OAuth2 Authorize Exchange Spec Customizer] Configure.");
        return customizer;
    }

    @Bean
    @ConditionalOnMissingBean
    public OAuth2ResourceServerSpecCustomizer oauth2ResourceServerSpecCustomizer(OAuth2AuthorizationProperties authorizationProperties, OAuth2ResourceServerProperties resourceServerProperties, ReactiveOpaqueTokenIntrospector reactiveOpaqueTokenIntrospector) {
        OAuth2ResourceServerSpecCustomizer customizer = new OAuth2ResourceServerSpecCustomizer(authorizationProperties, resourceServerProperties, reactiveOpaqueTokenIntrospector);
        log.trace("[Herodotus] |- Bean [OAuth2 Resource Server Spec Customizer] Configure.");
        return customizer;
    }

    @Bean
    @ConditionalOnMissingBean
    public SecurityAttributeAnalyzer securityAttributeAnalyzer(SecurityAttributeStorage securityAttributeStorage, ReactiveOAuth2ResourceMatcherConfigurer reactiveOAuth2ResourceMatcherConfigurer) {
        SecurityAttributeAnalyzer securityAttributeAnalyzer = new SecurityAttributeAnalyzer(securityAttributeStorage, reactiveOAuth2ResourceMatcherConfigurer.getPermitAllAttributes());
        log.trace("[Herodotus] |- Bean [Security Attribute Analyzer] Configure.");
        return securityAttributeAnalyzer;
    }
}

