/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authorization.servlet;

import cn.herodotus.stirrup.oauth2.authorization.definition.AbstractSecurityMatcherConfigurer;
import cn.herodotus.stirrup.oauth2.authorization.properties.OAuth2AuthorizationProperties;
import cn.herodotus.stirrup.web.servlet.utils.WebUtils;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.servlet.resource.ResourceUrlProvider;

public class ServletSecurityMatcherConfigurer
extends AbstractSecurityMatcherConfigurer {
    private final ResourceUrlProvider resourceUrlProvider;
    private final RequestMatcher[] staticRequestMatchers;
    private final RequestMatcher[] permitAllRequestMatchers;
    private final RequestMatcher[] hasAuthenticatedRequestMatchers;

    public ServletSecurityMatcherConfigurer(OAuth2AuthorizationProperties authorizationProperties, ResourceUrlProvider resourceUrlProvider) {
        super(authorizationProperties);
        this.resourceUrlProvider = resourceUrlProvider;
        this.staticRequestMatchers = WebUtils.toRequestMatchers(this.getStaticResources());
        this.permitAllRequestMatchers = WebUtils.toRequestMatchers(this.getPermitAllResources());
        this.hasAuthenticatedRequestMatchers = WebUtils.toRequestMatchers(this.getHasAuthenticatedResources());
    }

    public RequestMatcher[] getStaticRequestMatchers() {
        return this.staticRequestMatchers;
    }

    public RequestMatcher[] getPermitAllRequestMatchers() {
        return this.permitAllRequestMatchers;
    }

    public RequestMatcher[] getHasAuthenticatedRequestMatchers() {
        return this.hasAuthenticatedRequestMatchers;
    }

    public boolean isStaticRequest(String uri) {
        String staticUri = this.resourceUrlProvider.getForLookupPath(uri);
        return StringUtils.isNotBlank((CharSequence)staticUri);
    }

    public boolean isPermitAllRequest(HttpServletRequest request) {
        return WebUtils.isRequestMatched((RequestMatcher[])this.getPermitAllRequestMatchers(), (HttpServletRequest)request);
    }

    public boolean isHasAuthenticatedRequest(HttpServletRequest request) {
        return WebUtils.isRequestMatched((RequestMatcher[])this.getHasAuthenticatedRequestMatchers(), (HttpServletRequest)request);
    }
}

