/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authorization.servlet;

import cn.herodotus.stirrup.oauth2.authorization.definition.HerodotusRequest;
import cn.herodotus.stirrup.oauth2.authorization.definition.HerodotusRequestMatcher;
import cn.herodotus.stirrup.oauth2.authorization.definition.HerodotusSecurityAttribute;
import cn.herodotus.stirrup.oauth2.authorization.processor.SecurityAttributeStorage;
import cn.herodotus.stirrup.oauth2.authorization.servlet.ServletSecurityMatcherConfigurer;
import cn.herodotus.stirrup.web.servlet.utils.HeaderUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.access.expression.WebExpressionAuthorizationManager;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;

public class ServletSecurityAuthorizationManager
implements AuthorizationManager<RequestAuthorizationContext> {
    private static final Logger log = LoggerFactory.getLogger(ServletSecurityAuthorizationManager.class);
    private final SecurityAttributeStorage securityAttributeStorage;
    private final ServletSecurityMatcherConfigurer servletSecurityMatcherConfigurer;

    public ServletSecurityAuthorizationManager(SecurityAttributeStorage securityAttributeStorage, ServletSecurityMatcherConfigurer servletSecurityMatcherConfigurer) {
        this.securityAttributeStorage = securityAttributeStorage;
        this.servletSecurityMatcherConfigurer = servletSecurityMatcherConfigurer;
    }

    public AuthorizationDecision check(Supplier<Authentication> authentication, RequestAuthorizationContext object) {
        HttpServletRequest request = object.getRequest();
        String url = request.getRequestURI();
        String method = request.getMethod();
        if (this.servletSecurityMatcherConfigurer.isStaticRequest(url)) {
            log.trace("[Herodotus] |- Is static resource : [{}], Passed!", (Object)url);
            return new AuthorizationDecision(true);
        }
        if (this.servletSecurityMatcherConfigurer.isPermitAllRequest(request)) {
            log.trace("[Herodotus] |- Is white list resource : [{}], Passed!", (Object)url);
            return new AuthorizationDecision(true);
        }
        String feignInnerFlag = HeaderUtils.getHerodotusFromIn((HttpServletRequest)request);
        if (StringUtils.isNotBlank((CharSequence)feignInnerFlag)) {
            log.trace("[Herodotus] |- Is feign inner invoke : [{}], Passed!", (Object)url);
            return new AuthorizationDecision(true);
        }
        if (this.servletSecurityMatcherConfigurer.isHasAuthenticatedRequest(request)) {
            log.trace("[Herodotus] |- Is has authenticated resource : [{}]", (Object)url);
            return new AuthorizationDecision(authentication.get().isAuthenticated());
        }
        List<HerodotusSecurityAttribute> configAttributes = this.findConfigAttribute(url, method, request);
        if (CollectionUtils.isEmpty(configAttributes)) {
            log.warn("[Herodotus] |- NO PRIVILEGES : [{}].", (Object)url);
            if (!this.servletSecurityMatcherConfigurer.isStrictMode() && authentication.get().isAuthenticated()) {
                log.debug("[Herodotus] |- Request is authenticated: [{}].", (Object)url);
                return new AuthorizationDecision(true);
            }
            return new AuthorizationDecision(false);
        }
        for (HerodotusSecurityAttribute configAttribute : configAttributes) {
            WebExpressionAuthorizationManager webExpressionAuthorizationManager = new WebExpressionAuthorizationManager(configAttribute.getExpression());
            AuthorizationDecision decision = webExpressionAuthorizationManager.check(authentication, object);
            if (!decision.isGranted()) continue;
            log.debug("[Herodotus] |- Request [{}] is authorized!", (Object)object.getRequest().getRequestURI());
            return decision;
        }
        return new AuthorizationDecision(false);
    }

    private List<HerodotusSecurityAttribute> findConfigAttribute(String url, String method, HttpServletRequest request) {
        log.debug("[Herodotus] |- Current Request is : [{}] - [{}]", (Object)url, (Object)method);
        List<HerodotusSecurityAttribute> configAttributes = this.securityAttributeStorage.getConfigAttribute(url, method);
        if (CollectionUtils.isNotEmpty(configAttributes)) {
            log.debug("[Herodotus] |- Get configAttributes from local storage for : [{}] - [{}]", (Object)url, (Object)method);
            return configAttributes;
        }
        Map<HerodotusRequest, List<HerodotusSecurityAttribute>> compatible = this.securityAttributeStorage.getCompatible();
        if (MapUtils.isNotEmpty(compatible)) {
            for (Map.Entry<HerodotusRequest, List<HerodotusSecurityAttribute>> entry : compatible.entrySet()) {
                HerodotusRequestMatcher requestMatcher = new HerodotusRequestMatcher(entry.getKey());
                if (!requestMatcher.matches(request)) continue;
                log.debug("[Herodotus] |- Request match the wildcard [{}] - [{}]", (Object)entry.getKey(), entry.getValue());
                return entry.getValue();
            }
        }
        return null;
    }
}

