/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authorization.servlet;

import cn.herodotus.stirrup.core.definition.domain.Result;
import cn.herodotus.stirrup.core.definition.exception.PlatformRuntimeException;
import cn.herodotus.stirrup.oauth2.core.exception.PlatformAuthenticationException;
import cn.herodotus.stirrup.oauth2.core.exception.SecurityGlobalExceptionHandler;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;

@RestControllerAdvice
public class ServletRestControllerAdvice {
    @ExceptionHandler(value={HttpClientErrorException.class, HttpServerErrorException.class})
    public static Result<String> restTemplateException(Exception ex, HttpServletRequest request, HttpServletResponse response) {
        Result result = SecurityGlobalExceptionHandler.resolveException((Exception)ex, (String)request.getRequestURI());
        response.setStatus(result.getStatus());
        return result;
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public static Result<String> validationMethodArgumentException(MethodArgumentNotValidException ex, HttpServletRequest request, HttpServletResponse response) {
        return ServletRestControllerAdvice.validationBindException((BindException)ex, request, response);
    }

    @ExceptionHandler(value={BindException.class})
    public static Result<String> validationBindException(BindException ex, HttpServletRequest request, HttpServletResponse response) {
        Result result = SecurityGlobalExceptionHandler.resolveException((Exception)ex, (String)request.getRequestURI());
        BindingResult bindingResult = ex.getBindingResult();
        FieldError fieldError = bindingResult.getFieldError();
        if (ObjectUtils.isNotEmpty((Object)fieldError)) {
            result.validation(fieldError.getDefaultMessage(), fieldError.getCode(), fieldError.getField());
        }
        response.setStatus(result.getStatus());
        return result;
    }

    @ExceptionHandler(value={AuthenticationException.class, PlatformAuthenticationException.class})
    public static Result<String> authenticationException(Exception ex, HttpServletRequest request, HttpServletResponse response) {
        Result result = SecurityGlobalExceptionHandler.resolveSecurityException((Exception)ex, (String)request.getRequestURI());
        response.setStatus(result.getStatus());
        return result;
    }

    @ExceptionHandler(value={OAuth2AuthenticationException.class})
    public static Result<String> oAuth2AuthenticationException(Exception ex, HttpServletRequest request, HttpServletResponse response) {
        Result result = SecurityGlobalExceptionHandler.resolveSecurityException((Exception)ex, (String)request.getRequestURI());
        response.setStatus(result.getStatus());
        return result;
    }

    @ExceptionHandler(value={Exception.class, PlatformRuntimeException.class})
    public static Result<String> exception(Exception ex, HttpServletRequest request, HttpServletResponse response) {
        Result result = SecurityGlobalExceptionHandler.resolveException((Exception)ex, (String)request.getRequestURI());
        response.setStatus(result.getStatus());
        return result;
    }
}

