/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authorization.reactive;

import cn.herodotus.stirrup.core.foundation.utils.type.ListUtils;
import cn.herodotus.stirrup.oauth2.authorization.definition.AbstractSecurityMatcherConfigurer;
import cn.herodotus.stirrup.oauth2.authorization.properties.OAuth2AuthorizationProperties;
import cn.herodotus.stirrup.web.reactive.utils.WebFluxUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.reactive.resource.ResourceUrlProvider;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ReactiveSecurityMatcherConfigurer
extends AbstractSecurityMatcherConfigurer {
    private final ResourceUrlProvider resourceUrlProvider;
    private final String[] staticRequestMatchers;
    private final String[] permitAllRequestMatchers;
    private final String[] hasAuthenticatedRequestMatchers;

    public ReactiveSecurityMatcherConfigurer(OAuth2AuthorizationProperties authorizationProperties, ResourceUrlProvider resourceUrlProvider) {
        super(authorizationProperties);
        this.resourceUrlProvider = resourceUrlProvider;
        this.staticRequestMatchers = ListUtils.toStringArray(this.getStaticResources());
        this.permitAllRequestMatchers = ListUtils.toStringArray(this.getPermitAllResources());
        this.hasAuthenticatedRequestMatchers = ListUtils.toStringArray(this.getHasAuthenticatedResources());
    }

    public String[] getStaticRequestMatchers() {
        return this.staticRequestMatchers;
    }

    public String[] getPermitAllRequestMatchers() {
        return this.permitAllRequestMatchers;
    }

    public String[] getHasAuthenticatedRequestMatchers() {
        return this.hasAuthenticatedRequestMatchers;
    }

    public Mono<Boolean> isStaticRequest(String uri, ServerWebExchange exchange) {
        Mono staticUri = this.resourceUrlProvider.getForUriString(uri, exchange);
        return staticUri.flatMap(resource -> Mono.just((Object)StringUtils.isNotBlank((CharSequence)resource)));
    }

    public boolean isPermitAllRequest(String uri) {
        return WebFluxUtils.isPathMatch((String[])this.getPermitAllRequestMatchers(), (String)uri);
    }

    public boolean isHasAuthenticatedRequest(String uri) {
        return WebFluxUtils.isPathMatch((String[])this.getHasAuthenticatedRequestMatchers(), (String)uri);
    }
}

