/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authorization.reactive;

import cn.herodotus.stirrup.core.definition.domain.Result;
import cn.herodotus.stirrup.core.definition.exception.PlatformRuntimeException;
import cn.herodotus.stirrup.oauth2.core.exception.PlatformAuthenticationException;
import cn.herodotus.stirrup.oauth2.core.exception.SecurityGlobalExceptionHandler;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.server.ServerWebExchange;

@RestControllerAdvice
public class ReactiveRestControllerAdvice {
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public static Result<String> validationMethodArgumentException(MethodArgumentNotValidException ex, ServerWebExchange serverWebExchange) {
        return ReactiveRestControllerAdvice.validationBindException((BindException)ex, serverWebExchange);
    }

    @ExceptionHandler(value={BindException.class})
    public static Result<String> validationBindException(BindException ex, ServerWebExchange serverWebExchange) {
        ServerHttpRequest request = serverWebExchange.getRequest();
        ServerHttpResponse response = serverWebExchange.getResponse();
        Result result = SecurityGlobalExceptionHandler.resolveException((Exception)ex, (String)request.getURI().getPath());
        BindingResult bindingResult = ex.getBindingResult();
        FieldError fieldError = bindingResult.getFieldError();
        if (ObjectUtils.isNotEmpty((Object)fieldError)) {
            result.validation(fieldError.getDefaultMessage(), fieldError.getCode(), fieldError.getField());
        }
        response.setStatusCode(HttpStatusCode.valueOf((int)result.getStatus()));
        return result;
    }

    @ExceptionHandler(value={AuthenticationException.class, PlatformAuthenticationException.class})
    public static Result<String> authenticationException(Exception ex, ServerWebExchange serverWebExchange) {
        ServerHttpRequest request = serverWebExchange.getRequest();
        ServerHttpResponse response = serverWebExchange.getResponse();
        Result result = SecurityGlobalExceptionHandler.resolveSecurityException((Exception)ex, (String)request.getURI().getPath());
        response.setStatusCode(HttpStatusCode.valueOf((int)result.getStatus()));
        return result;
    }

    @ExceptionHandler(value={OAuth2AuthenticationException.class})
    public static Result<String> oAuth2AuthenticationException(Exception ex, ServerWebExchange serverWebExchange) {
        ServerHttpRequest request = serverWebExchange.getRequest();
        ServerHttpResponse response = serverWebExchange.getResponse();
        Result result = SecurityGlobalExceptionHandler.resolveSecurityException((Exception)ex, (String)request.getURI().getPath());
        response.setStatusCode(HttpStatusCode.valueOf((int)result.getStatus()));
        return result;
    }

    @ExceptionHandler(value={Exception.class, PlatformRuntimeException.class})
    public static Result<String> exception(Exception ex, ServerWebExchange serverWebExchange) {
        ServerHttpRequest request = serverWebExchange.getRequest();
        ServerHttpResponse response = serverWebExchange.getResponse();
        Result result = SecurityGlobalExceptionHandler.resolveException((Exception)ex, (String)request.getURI().getPath());
        response.setStatusCode(HttpStatusCode.valueOf((int)result.getStatus()));
        return result;
    }
}

