/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authorization.reactive;

import cn.herodotus.stirrup.core.foundation.enums.Target;
import cn.herodotus.stirrup.oauth2.authorization.properties.OAuth2AuthorizationProperties;
import cn.herodotus.stirrup.oauth2.authorization.reactive.HerodotusReactiveOpaqueTokenIntrospector;
import cn.herodotus.stirrup.oauth2.authorization.reactive.HerodotusServerAccessDeniedHandler;
import cn.herodotus.stirrup.oauth2.authorization.reactive.HerodotusServerAuthenticationEntryPoint;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.oauth2.server.resource.introspection.ReactiveOpaqueTokenIntrospector;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.authorization.ServerAccessDeniedHandler;

public class OAuth2ResourceServerSpecCustomizer
implements Customizer<ServerHttpSecurity.OAuth2ResourceServerSpec> {
    private final OAuth2AuthorizationProperties authorizationProperties;
    private final OAuth2ResourceServerProperties resourceServerProperties;
    private final ReactiveOpaqueTokenIntrospector opaqueTokenIntrospector;

    public OAuth2ResourceServerSpecCustomizer(OAuth2AuthorizationProperties authorizationProperties, OAuth2ResourceServerProperties resourceServerProperties) {
        this.authorizationProperties = authorizationProperties;
        this.resourceServerProperties = resourceServerProperties;
        this.opaqueTokenIntrospector = new HerodotusReactiveOpaqueTokenIntrospector(resourceServerProperties);
    }

    private boolean isRemoteValidate() {
        return this.authorizationProperties.getValidate() == Target.REMOTE;
    }

    public void customize(ServerHttpSecurity.OAuth2ResourceServerSpec spec) {
        if (this.isRemoteValidate()) {
            spec.opaqueToken(opaque -> opaque.introspector(this.opaqueTokenIntrospector));
        } else {
            spec.jwt(jwt -> jwt.jwkSetUri(this.resourceServerProperties.getJwt().getJwkSetUri()));
        }
        spec.accessDeniedHandler((ServerAccessDeniedHandler)new HerodotusServerAccessDeniedHandler()).authenticationEntryPoint((ServerAuthenticationEntryPoint)new HerodotusServerAuthenticationEntryPoint());
    }
}

