/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authorization.reactive;

import cn.herodotus.stirrup.core.foundation.context.ServiceContextHolder;
import cn.herodotus.stirrup.oauth2.core.definition.domain.HerodotusGrantedAuthority;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpStatus;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.introspection.BadOpaqueTokenException;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionAuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionException;
import org.springframework.security.oauth2.server.resource.introspection.ReactiveOpaqueTokenIntrospector;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class HerodotusReactiveOpaqueTokenIntrospector
implements ReactiveOpaqueTokenIntrospector {
    private static final String AUTHORITY_PREFIX = "SCOPE_";
    private static final ParameterizedTypeReference<Map<String, Object>> STRING_OBJECT_MAP = new ParameterizedTypeReference<Map<String, Object>>(){};
    private final URI introspectionUri;
    private final WebClient webClient;

    public HerodotusReactiveOpaqueTokenIntrospector(OAuth2ResourceServerProperties resourceServerProperties) {
        this(HerodotusReactiveOpaqueTokenIntrospector.getIntrospectionUri(resourceServerProperties), resourceServerProperties.getOpaquetoken().getClientId(), resourceServerProperties.getOpaquetoken().getClientSecret());
    }

    public HerodotusReactiveOpaqueTokenIntrospector(String introspectionUri, String clientId, String clientSecret) {
        Assert.hasText((String)introspectionUri, (String)"introspectionUri cannot be empty");
        Assert.hasText((String)clientId, (String)"clientId cannot be empty");
        Assert.notNull((Object)clientSecret, (String)"clientSecret cannot be null");
        this.introspectionUri = URI.create(introspectionUri);
        this.webClient = WebClient.builder().defaultHeaders(h -> h.setBasicAuth(clientId, clientSecret)).build();
    }

    public HerodotusReactiveOpaqueTokenIntrospector(String introspectionUri, WebClient webClient) {
        Assert.hasText((String)introspectionUri, (String)"introspectionUri cannot be null");
        Assert.notNull((Object)webClient, (String)"webClient cannot be null");
        this.introspectionUri = URI.create(introspectionUri);
        this.webClient = webClient;
    }

    private static String getIntrospectionUri(OAuth2ResourceServerProperties resourceServerProperties) {
        String introspectionUri = ServiceContextHolder.getInstance().getTokenIntrospectionUri();
        String configIntrospectionUri = resourceServerProperties.getOpaquetoken().getIntrospectionUri();
        if (StringUtils.isNotBlank((CharSequence)configIntrospectionUri)) {
            introspectionUri = configIntrospectionUri;
        }
        return introspectionUri;
    }

    public Mono<OAuth2AuthenticatedPrincipal> introspect(String token) {
        return Mono.just((Object)token).flatMap(this::makeRequest).flatMap(this::adaptToNimbusResponse).map(this::convertClaimsSet).onErrorMap(e -> !(e instanceof OAuth2IntrospectionException), this::onError);
    }

    private Mono<ClientResponse> makeRequest(String token) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(this.introspectionUri)).header("Accept", new String[]{"application/json"})).body((BodyInserter)BodyInserters.fromFormData((String)"token", (String)token)).exchange();
    }

    private Mono<Map<String, Object>> adaptToNimbusResponse(ClientResponse responseEntity) {
        if (responseEntity.statusCode() != HttpStatus.OK) {
            return responseEntity.bodyToFlux(DataBuffer.class).map(DataBufferUtils::release).then(Mono.error((Throwable)new OAuth2IntrospectionException("Introspection endpoint responded with " + String.valueOf(responseEntity.statusCode()))));
        }
        return responseEntity.bodyToMono(STRING_OBJECT_MAP).filter(body -> (Boolean)body.compute("active", (k, v) -> {
            if (v instanceof String) {
                return Boolean.parseBoolean((String)v);
            }
            if (v instanceof Boolean) {
                return v;
            }
            return false;
        })).switchIfEmpty(Mono.error(() -> new BadOpaqueTokenException("Provided token isn't active")));
    }

    private OAuth2AuthenticatedPrincipal convertClaimsSet(Map<String, Object> claims) {
        claims.computeIfPresent("aud", (k, v) -> {
            if (v instanceof String) {
                return Collections.singletonList(v);
            }
            return v;
        });
        claims.computeIfPresent("client_id", (k, v) -> v.toString());
        claims.computeIfPresent("exp", (k, v) -> Instant.ofEpochSecond(((Number)v).longValue()));
        claims.computeIfPresent("iat", (k, v) -> Instant.ofEpochSecond(((Number)v).longValue()));
        claims.computeIfPresent("iss", (k, v) -> v.toString());
        claims.computeIfPresent("nbf", (k, v) -> Instant.ofEpochSecond(((Number)v).longValue()));
        ArrayList authorities = new ArrayList();
        claims.computeIfPresent("scope", (k, v) -> v.toString());
        claims.computeIfPresent("authorities", (k, v) -> {
            if (v instanceof ArrayList) {
                List values = (List)v;
                values.forEach(value -> authorities.add(new HerodotusGrantedAuthority(value)));
            }
            return v;
        });
        return new OAuth2IntrospectionAuthenticatedPrincipal(claims, authorities);
    }

    private OAuth2IntrospectionException onError(Throwable ex) {
        return new OAuth2IntrospectionException(ex.getMessage(), ex);
    }
}

