/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authorization.processor;

import cn.herodotus.stirrup.cache.jetcache.utils.JetCacheUtils;
import cn.herodotus.stirrup.oauth2.authorization.definition.HerodotusRequest;
import cn.herodotus.stirrup.oauth2.authorization.definition.HerodotusRequestMatcher;
import cn.herodotus.stirrup.oauth2.authorization.definition.HerodotusSecurityAttribute;
import com.alicp.jetcache.Cache;
import com.alicp.jetcache.anno.CacheType;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SecurityAttributeStorage {
    private static final Logger log = LoggerFactory.getLogger(SecurityAttributeStorage.class);
    private static final String KEY_COMPATIBLE = "COMPATIBLE";
    private final Cache<String, Map<HerodotusRequest, List<HerodotusSecurityAttribute>>> compatible = JetCacheUtils.create((String)"cache:security:metadata:compatible:", (CacheType)CacheType.BOTH, null, (Boolean)true, (Boolean)true);
    private final Cache<HerodotusRequest, List<HerodotusSecurityAttribute>> indexable = JetCacheUtils.create((String)"cache:security:metadata:indexable:", (CacheType)CacheType.BOTH, null, (Boolean)true, (Boolean)true);

    private Map<HerodotusRequest, List<HerodotusSecurityAttribute>> readFromCompatible() {
        Map compatible = (Map)this.compatible.get((Object)KEY_COMPATIBLE);
        if (MapUtils.isNotEmpty((Map)compatible)) {
            return compatible;
        }
        return new LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>>();
    }

    private void writeToCompatible(Map<HerodotusRequest, List<HerodotusSecurityAttribute>> compatible) {
        this.compatible.put((Object)KEY_COMPATIBLE, compatible);
    }

    private List<HerodotusSecurityAttribute> readFromIndexable(HerodotusRequest herodotusRequest) {
        return (List)this.indexable.get((Object)herodotusRequest);
    }

    private void writeToIndexable(HerodotusRequest herodotusRequest, List<HerodotusSecurityAttribute> configAttributes) {
        this.indexable.put((Object)herodotusRequest, configAttributes);
    }

    public List<HerodotusSecurityAttribute> getConfigAttribute(String url, String method) {
        HerodotusRequest herodotusRequest = new HerodotusRequest(url, method);
        return this.readFromIndexable(herodotusRequest);
    }

    public Map<HerodotusRequest, List<HerodotusSecurityAttribute>> getCompatible() {
        return this.readFromCompatible();
    }

    private void appendToCompatible(HerodotusRequest herodotusRequest, List<HerodotusSecurityAttribute> configAttributes) {
        Map<HerodotusRequest, List<HerodotusSecurityAttribute>> compatible = this.getCompatible();
        compatible.put(herodotusRequest, configAttributes);
        log.trace("[Herodotus] |- Append [{}] to Compatible cache, current size is [{}]", (Object)herodotusRequest, (Object)compatible.size());
        this.writeToCompatible(compatible);
    }

    private void appendToCompatible(Map<HerodotusRequest, List<HerodotusSecurityAttribute>> configAttributes) {
        Map<HerodotusRequest, List<HerodotusSecurityAttribute>> compatible = this.getCompatible();
        compatible.putAll(configAttributes);
        this.writeToCompatible(compatible);
    }

    private void appendToIndexable(HerodotusRequest herodotusRequest, List<HerodotusSecurityAttribute> configAttributes) {
        this.writeToIndexable(herodotusRequest, configAttributes);
    }

    private void appendToIndexable(Map<HerodotusRequest, List<HerodotusSecurityAttribute>> configAttributes) {
        this.indexable.putAll(configAttributes);
    }

    public void addToStorage(Map<HerodotusRequest, List<HerodotusSecurityAttribute>> configAttributes, boolean isIndexable) {
        if (MapUtils.isNotEmpty(configAttributes)) {
            if (isIndexable) {
                this.appendToIndexable(configAttributes);
            } else {
                this.appendToCompatible(configAttributes);
            }
        }
    }

    public void addToStorage(Map<HerodotusRequest, List<HerodotusSecurityAttribute>> matchers, Map<HerodotusRequest, List<HerodotusSecurityAttribute>> configAttributes, boolean isIndexable) {
        Map<HerodotusRequest, List<HerodotusSecurityAttribute>> result = new LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>>();
        if (MapUtils.isNotEmpty(matchers) && MapUtils.isNotEmpty(configAttributes)) {
            result = this.checkConflict(matchers, configAttributes);
        }
        this.addToStorage(result, isIndexable);
    }

    private Map<HerodotusRequest, List<HerodotusSecurityAttribute>> checkConflict(Map<HerodotusRequest, List<HerodotusSecurityAttribute>> matchers, Map<HerodotusRequest, List<HerodotusSecurityAttribute>> configAttributes) {
        LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> result = new LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>>(configAttributes);
        for (HerodotusRequest matcher : matchers.keySet()) {
            Iterator<HerodotusRequest> iterator = configAttributes.keySet().iterator();
            while (iterator.hasNext()) {
                HerodotusRequestMatcher requestMatcher = new HerodotusRequestMatcher(matcher);
                HerodotusRequest item = iterator.next();
                if (!requestMatcher.matches(item)) continue;
                result.remove(item);
                log.trace("[Herodotus] |- Pattern [{}] is conflict with [{}], so remove it.", (Object)item.getPattern(), (Object)matcher.getPattern());
            }
        }
        return result;
    }
}

