/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authorization.processor;

import cn.herodotus.stirrup.oauth2.authorization.definition.HerodotusRequest;
import cn.herodotus.stirrup.oauth2.authorization.definition.HerodotusSecurityAttribute;
import cn.herodotus.stirrup.oauth2.authorization.enums.Category;
import cn.herodotus.stirrup.oauth2.authorization.processor.SecurityAttributeStorage;
import cn.herodotus.stirrup.oauth2.core.definition.domain.AttributeTransmitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SecurityAttributeAnalyzer {
    private static final Logger log = LoggerFactory.getLogger(SecurityAttributeAnalyzer.class);
    private final SecurityAttributeStorage securityAttributeStorage;
    private final Map<HerodotusRequest, List<HerodotusSecurityAttribute>> permitAllAttributes;

    public SecurityAttributeAnalyzer(SecurityAttributeStorage securityAttributeStorage, Map<HerodotusRequest, List<HerodotusSecurityAttribute>> permitAllAttributes) {
        this.securityAttributeStorage = securityAttributeStorage;
        this.permitAllAttributes = permitAllAttributes;
    }

    private String hasAuthority(String authority) {
        return "hasAuthority('" + authority + "')";
    }

    private void appendToGroup(Map<Category, Map<HerodotusRequest, List<HerodotusSecurityAttribute>>> container, Category category, Map<HerodotusRequest, List<HerodotusSecurityAttribute>> resources) {
        Map<HerodotusRequest, List<HerodotusSecurityAttribute>> value = new LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>>();
        if (container.containsKey((Object)category)) {
            value = container.get((Object)category);
        }
        value.putAll(resources);
        container.put(category, value);
    }

    private Map<Category, Map<HerodotusRequest, List<HerodotusSecurityAttribute>>> groupingSecurityMatchers(Map<HerodotusRequest, List<HerodotusSecurityAttribute>> securityMatchers) {
        LinkedHashMap<Category, Map<HerodotusRequest, List<HerodotusSecurityAttribute>>> group = new LinkedHashMap<Category, Map<HerodotusRequest, List<HerodotusSecurityAttribute>>>();
        securityMatchers.forEach((key, value) -> {
            LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> resources = new LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>>();
            resources.put((HerodotusRequest)key, (List<HerodotusSecurityAttribute>)value);
            this.appendToGroup(group, Category.getCategory(key.getPattern()), resources);
        });
        log.debug("[Herodotus] |- Grouping security matcher by category.");
        return group;
    }

    private List<HerodotusSecurityAttribute> analysis(AttributeTransmitter attributeTransmitter) {
        ArrayList<HerodotusSecurityAttribute> attributes = new ArrayList<HerodotusSecurityAttribute>();
        if (StringUtils.isNotBlank((CharSequence)attributeTransmitter.getPermissions())) {
            String[] permissions = org.springframework.util.StringUtils.commaDelimitedListToStringArray((String)attributeTransmitter.getPermissions());
            Arrays.stream(permissions).forEach(item -> attributes.add(HerodotusSecurityAttribute.create(this.hasAuthority((String)item), attributeTransmitter.getClassName(), attributeTransmitter.getMethodName())));
        }
        if (StringUtils.isNotBlank((CharSequence)attributeTransmitter.getWebExpression())) {
            attributes.add(HerodotusSecurityAttribute.create(attributeTransmitter.getWebExpression(), attributeTransmitter.getClassName(), attributeTransmitter.getMethodName()));
        }
        return attributes;
    }

    private Map<HerodotusRequest, List<HerodotusSecurityAttribute>> convert(String url, String methods, List<HerodotusSecurityAttribute> configAttributes) {
        LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> result = new LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>>();
        if (StringUtils.isBlank((CharSequence)methods)) {
            result.put(new HerodotusRequest(url), configAttributes);
        } else if (StringUtils.contains((CharSequence)methods, (CharSequence)",")) {
            String[] multiMethod;
            for (String method : multiMethod = StringUtils.split((String)methods, (String)",")) {
                result.put(new HerodotusRequest(url, method), configAttributes);
            }
        } else {
            result.put(new HerodotusRequest(url, methods), configAttributes);
        }
        return result;
    }

    private Map<Category, Map<HerodotusRequest, List<HerodotusSecurityAttribute>>> groupingAttributeTransmitters(List<AttributeTransmitter> attributeTransmitters) {
        LinkedHashMap<Category, Map<HerodotusRequest, List<HerodotusSecurityAttribute>>> group = new LinkedHashMap<Category, Map<HerodotusRequest, List<HerodotusSecurityAttribute>>>();
        attributeTransmitters.forEach(attributeTransmitter -> {
            Map<HerodotusRequest, List<HerodotusSecurityAttribute>> resources = this.convert(attributeTransmitter.getUrl(), attributeTransmitter.getRequestMethod(), this.analysis((AttributeTransmitter)attributeTransmitter));
            this.appendToGroup(group, Category.getCategory(attributeTransmitter.getUrl()), resources);
        });
        log.debug("[Herodotus] |- Grouping security metadata by category.");
        return group;
    }

    public void processLocalSecurityMatchers() {
        log.debug("[Herodotus] |- [3] Process local configured security attribute.");
        if (MapUtils.isNotEmpty(this.permitAllAttributes)) {
            Map<Category, Map<HerodotusRequest, List<HerodotusSecurityAttribute>>> grouping = this.groupingSecurityMatchers(this.permitAllAttributes);
            Map<HerodotusRequest, List<HerodotusSecurityAttribute>> wildcards = grouping.get((Object)Category.WILDCARD);
            this.securityAttributeStorage.addToStorage(wildcards, false);
            Map<HerodotusRequest, List<HerodotusSecurityAttribute>> fullPaths = grouping.get((Object)Category.FULL_PATH);
            this.securityAttributeStorage.addToStorage(fullPaths, true);
        }
    }

    public void processAttributeTransmitters(List<AttributeTransmitter> attributeTransmitters) {
        Map<HerodotusRequest, List<HerodotusSecurityAttribute>> compatibles = this.securityAttributeStorage.getCompatible();
        LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> matchers = new LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>>(compatibles);
        Map<Category, Map<HerodotusRequest, List<HerodotusSecurityAttribute>>> grouping = this.groupingAttributeTransmitters(attributeTransmitters);
        Map<HerodotusRequest, List<HerodotusSecurityAttribute>> wildcards = grouping.get((Object)Category.WILDCARD);
        if (MapUtils.isNotEmpty(wildcards)) {
            matchers.putAll(wildcards);
            this.securityAttributeStorage.addToStorage(wildcards, false);
        }
        Map<HerodotusRequest, List<HerodotusSecurityAttribute>> placeholders = grouping.get((Object)Category.PLACEHOLDER);
        log.debug("[Herodotus] |- Store placeholder type security attributes.");
        this.securityAttributeStorage.addToStorage(matchers, placeholders, false);
        Map<HerodotusRequest, List<HerodotusSecurityAttribute>> fullPaths = grouping.get((Object)Category.FULL_PATH);
        log.debug("[Herodotus] |- Store full path type security attributes.");
        this.securityAttributeStorage.addToStorage(matchers, fullPaths, true);
        log.debug("[Herodotus] |- [7] Security attributes process has FINISHED!");
    }
}

