/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authorization.definition;

import cn.herodotus.stirrup.oauth2.core.servlet.enums.PermissionExpression;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.io.Serializable;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.dromara.hutool.extra.spring.SpringUtil;
import org.springframework.security.util.MethodInvocationUtils;

public class HerodotusSecurityAttribute
implements Serializable {
    private String expression;
    private String className;
    private String methodName;

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public static HerodotusSecurityAttribute create(String expression, String className, String methodName) {
        HerodotusSecurityAttribute attribute = new HerodotusSecurityAttribute();
        attribute.setExpression(expression);
        attribute.setClassName(className);
        attribute.setMethodName(methodName);
        return attribute;
    }

    public static HerodotusSecurityAttribute createDefaultPermitAll() {
        HerodotusSecurityAttribute attribute = new HerodotusSecurityAttribute();
        attribute.setExpression(PermissionExpression.PERMIT_ALL.getValue());
        attribute.setClassName(HerodotusSecurityAttribute.class.getName());
        attribute.setMethodName("getExpression");
        return attribute;
    }

    public static MethodInvocation createMethodInvocation(HerodotusSecurityAttribute attribute) {
        try {
            Class clazz = ClassUtils.getClass((String)attribute.getClassName());
            Object object = SpringUtil.getBean((Class)clazz);
            if (ObjectUtils.isEmpty((Object)object)) {
                return MethodInvocationUtils.createFromClass((Object)new HerodotusSecurityAttribute(), HerodotusSecurityAttribute.class, (String)attribute.getMethodName(), null, null);
            }
            return MethodInvocationUtils.createFromClass((Object)object, (Class)clazz, (String)attribute.getMethodName(), null, null);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HerodotusSecurityAttribute that = (HerodotusSecurityAttribute)o;
        return Objects.equal((Object)this.expression, (Object)that.expression);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.expression});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("attrib", (Object)this.expression).toString();
    }
}

