/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authorization.definition;

import cn.herodotus.stirrup.core.foundation.utils.type.ListUtils;
import cn.herodotus.stirrup.oauth2.authorization.definition.HerodotusRequest;
import cn.herodotus.stirrup.oauth2.authorization.definition.HerodotusSecurityAttribute;
import cn.herodotus.stirrup.oauth2.authorization.properties.OAuth2AuthorizationProperties;
import cn.herodotus.stirrup.oauth2.core.constants.SecurityResources;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractSecurityMatcherConfigurer {
    private final OAuth2AuthorizationProperties authorizationProperties;
    private final List<String> staticResources;
    private final List<String> permitAllResources;
    private final List<String> hasAuthenticatedResources;
    private final Map<HerodotusRequest, List<HerodotusSecurityAttribute>> permitAllAttributes;

    protected AbstractSecurityMatcherConfigurer(OAuth2AuthorizationProperties authorizationProperties) {
        this.authorizationProperties = authorizationProperties;
        this.staticResources = ListUtils.merge(authorizationProperties.getMatcher().getStaticResources(), (List)SecurityResources.DEFAULT_IGNORED_STATIC_RESOURCES);
        this.permitAllResources = ListUtils.merge(authorizationProperties.getMatcher().getPermitAll(), (List)SecurityResources.DEFAULT_PERMIT_ALL_RESOURCES);
        this.hasAuthenticatedResources = ListUtils.merge(authorizationProperties.getMatcher().getHasAuthenticated(), (List)SecurityResources.DEFAULT_HAS_AUTHENTICATED_RESOURCES);
        this.permitAllAttributes = this.createPermitAllAttributes(this.permitAllResources);
    }

    private Map<HerodotusRequest, List<HerodotusSecurityAttribute>> createPermitAllAttributes(List<String> permitAllResources) {
        if (CollectionUtils.isNotEmpty(permitAllResources)) {
            LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> result = new LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>>();
            permitAllResources.forEach(item -> result.put(new HerodotusRequest((String)item), List.of(HerodotusSecurityAttribute.createDefaultPermitAll())));
            return result;
        }
        return new LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>>();
    }

    public boolean isStrictMode() {
        return this.authorizationProperties.getStrict();
    }

    protected List<String> getStaticResources() {
        return this.staticResources;
    }

    protected List<String> getPermitAllResources() {
        return this.permitAllResources;
    }

    protected List<String> getHasAuthenticatedResources() {
        return this.hasAuthenticatedResources;
    }

    public Map<HerodotusRequest, List<HerodotusSecurityAttribute>> getPermitAllAttributes() {
        return this.permitAllAttributes;
    }
}

