/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authorization.configuration;

import cn.herodotus.stirrup.core.foundation.support.BearerTokenResolver;
import cn.herodotus.stirrup.oauth2.authorization.configuration.OAuth2SessionConfiguration;
import cn.herodotus.stirrup.oauth2.authorization.processor.SecurityAttributeAnalyzer;
import cn.herodotus.stirrup.oauth2.authorization.processor.SecurityAttributeStorage;
import cn.herodotus.stirrup.oauth2.authorization.properties.OAuth2AuthorizationProperties;
import cn.herodotus.stirrup.oauth2.authorization.servlet.OAuth2AuthorizeHttpRequestsConfigurerCustomer;
import cn.herodotus.stirrup.oauth2.authorization.servlet.OAuth2ResourceServerConfigurerCustomer;
import cn.herodotus.stirrup.oauth2.authorization.servlet.ServletRestControllerAdvice;
import cn.herodotus.stirrup.oauth2.authorization.servlet.ServletSecurityAuthorizationManager;
import cn.herodotus.stirrup.oauth2.authorization.servlet.ServletSecurityMatcherConfigurer;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.web.servlet.resource.ResourceUrlProvider;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@EnableConfigurationProperties(value={OAuth2AuthorizationProperties.class})
@EnableMethodSecurity(proxyTargetClass=true, securedEnabled=true, jsr250Enabled=true)
@Import(value={ServletRestControllerAdvice.class, OAuth2SessionConfiguration.class})
public class OAuth2ServletAuthorizationConfiguration {
    private static final Logger log = LoggerFactory.getLogger(OAuth2ServletAuthorizationConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- Module [OAuth2 Authorization] Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public SecurityAttributeStorage securityMetadataSourceStorage() {
        SecurityAttributeStorage storage = new SecurityAttributeStorage();
        log.trace("[Herodotus] |- Bean [Security Metadata Source Storage] Configure.");
        return storage;
    }

    @Bean
    @ConditionalOnMissingBean
    public ServletSecurityMatcherConfigurer servletSecurityMatcherConfigurer(OAuth2AuthorizationProperties authorizationProperties, ResourceUrlProvider resourceUrlProvider) {
        ServletSecurityMatcherConfigurer configurer = new ServletSecurityMatcherConfigurer(authorizationProperties, resourceUrlProvider);
        log.trace("[Herodotus] |- Bean [Servlet Security Matcher Configurer] Configure.");
        return configurer;
    }

    @Bean
    @ConditionalOnMissingBean
    public ServletSecurityAuthorizationManager servletSecurityAuthorizationManager(SecurityAttributeStorage securityAttributeStorage, ServletSecurityMatcherConfigurer servletSecurityMatcherConfigurer) {
        ServletSecurityAuthorizationManager manager = new ServletSecurityAuthorizationManager(securityAttributeStorage, servletSecurityMatcherConfigurer);
        log.trace("[Herodotus] |- Bean [Servlet Security Authorization Manager] Configure.");
        return manager;
    }

    @Bean
    @ConditionalOnMissingBean
    public OAuth2AuthorizeHttpRequestsConfigurerCustomer oauth2AuthorizeHttpRequestsConfigurerCustomer(ServletSecurityMatcherConfigurer servletSecurityMatcherConfigurer, ServletSecurityAuthorizationManager servletSecurityAuthorizationManager) {
        OAuth2AuthorizeHttpRequestsConfigurerCustomer customer = new OAuth2AuthorizeHttpRequestsConfigurerCustomer(servletSecurityMatcherConfigurer, servletSecurityAuthorizationManager);
        log.trace("[Herodotus] |- Bean [OAuth2 Authorize Http Requests Configurer Customer] Configure.");
        return customer;
    }

    @Bean
    @ConditionalOnMissingBean
    public OAuth2ResourceServerConfigurerCustomer oauth2ResourceServerConfigurerCustomer(OAuth2AuthorizationProperties authorizationProperties, JwtDecoder jwtDecoder, OAuth2ResourceServerProperties resourceServerProperties) {
        OAuth2ResourceServerConfigurerCustomer customer = new OAuth2ResourceServerConfigurerCustomer(authorizationProperties, jwtDecoder, resourceServerProperties);
        log.trace("[Herodotus] |- Bean [OAuth2 Resource Server Configurer Customer] Configure.");
        return customer;
    }

    @Bean
    @ConditionalOnMissingBean
    public SecurityAttributeAnalyzer securityAttributeAnalyzer(SecurityAttributeStorage securityAttributeStorage, ServletSecurityMatcherConfigurer servletSecurityMatcherConfigurer) {
        SecurityAttributeAnalyzer analyzer = new SecurityAttributeAnalyzer(securityAttributeStorage, servletSecurityMatcherConfigurer.getPermitAllAttributes());
        log.trace("[Herodotus] |- Bean [Security Attribute Analyzer] Configure.");
        return analyzer;
    }

    @Bean
    @ConditionalOnMissingBean
    public BearerTokenResolver bearerTokenResolver(OAuth2ResourceServerConfigurerCustomer oauth2ResourceServerConfigurerCustomer) {
        BearerTokenResolver bearerTokenResolver = oauth2ResourceServerConfigurerCustomer.createBearerTokenResolver();
        log.trace("[Herodotus] |- Bean [Bearer Token Resolver] Configure.");
        return bearerTokenResolver;
    }
}

