/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authorization.configuration;

import cn.herodotus.stirrup.oauth2.authorization.processor.SecurityAttributeAnalyzer;
import cn.herodotus.stirrup.oauth2.authorization.processor.SecurityAttributeStorage;
import cn.herodotus.stirrup.oauth2.authorization.properties.OAuth2AuthorizationProperties;
import cn.herodotus.stirrup.oauth2.authorization.reactive.OAuth2AuthorizeExchangeSpecCustomizer;
import cn.herodotus.stirrup.oauth2.authorization.reactive.OAuth2ResourceServerSpecCustomizer;
import cn.herodotus.stirrup.oauth2.authorization.reactive.ReactiveRestControllerAdvice;
import cn.herodotus.stirrup.oauth2.authorization.reactive.ReactiveSecurityAuthorizationManager;
import cn.herodotus.stirrup.oauth2.authorization.reactive.ReactiveSecurityMatcherConfigurer;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.config.annotation.method.configuration.EnableReactiveMethodSecurity;
import org.springframework.web.reactive.resource.ResourceUrlProvider;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@EnableConfigurationProperties(value={OAuth2AuthorizationProperties.class})
@EnableReactiveMethodSecurity
@Import(value={ReactiveRestControllerAdvice.class})
public class OAuth2ReactiveAuthorizationConfiguration {
    private static final Logger log = LoggerFactory.getLogger(OAuth2ReactiveAuthorizationConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- Module [OAuth2 Reactive Authorization] Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public SecurityAttributeStorage securityAttributeStorage() {
        SecurityAttributeStorage securityAttributeStorage = new SecurityAttributeStorage();
        log.trace("[Herodotus] |- Bean [Security Attribute Storage] Configure.");
        return securityAttributeStorage;
    }

    @Bean
    @ConditionalOnMissingBean
    public ReactiveSecurityMatcherConfigurer reactiveSecurityMatcherConfigurer(OAuth2AuthorizationProperties authorizationProperties, ResourceUrlProvider resourceUrlProvider) {
        ReactiveSecurityMatcherConfigurer configurer = new ReactiveSecurityMatcherConfigurer(authorizationProperties, resourceUrlProvider);
        log.trace("[Herodotus] |- Bean [Reactive Security Matcher Configurer] Configure.");
        return configurer;
    }

    @Bean
    @ConditionalOnMissingBean
    public ReactiveSecurityAuthorizationManager reactiveSecurityAuthorizationManager(SecurityAttributeStorage securityAttributeStorage, ReactiveSecurityMatcherConfigurer reactiveSecurityMatcherConfigurer) {
        ReactiveSecurityAuthorizationManager manager = new ReactiveSecurityAuthorizationManager(securityAttributeStorage, reactiveSecurityMatcherConfigurer);
        log.trace("[Herodotus] |- Bean [Reactive Security Authorization Manager] Configure.");
        return manager;
    }

    @Bean
    @ConditionalOnMissingBean
    public OAuth2AuthorizeExchangeSpecCustomizer oauth2AuthorizeExchangeSpecCustomizer(ReactiveSecurityMatcherConfigurer reactiveSecurityMatcherConfigurer, ReactiveSecurityAuthorizationManager reactiveSecurityAuthorizationManager) {
        OAuth2AuthorizeExchangeSpecCustomizer customizer = new OAuth2AuthorizeExchangeSpecCustomizer(reactiveSecurityMatcherConfigurer, reactiveSecurityAuthorizationManager);
        log.trace("[Herodotus] |- Bean [OAuth2 Authorize Exchange Spec Customizer] Configure.");
        return customizer;
    }

    @Bean
    @ConditionalOnMissingBean
    public OAuth2ResourceServerSpecCustomizer oauth2ResourceServerSpecCustomizer(OAuth2AuthorizationProperties authorizationProperties, OAuth2ResourceServerProperties resourceServerProperties) {
        OAuth2ResourceServerSpecCustomizer customizer = new OAuth2ResourceServerSpecCustomizer(authorizationProperties, resourceServerProperties);
        log.trace("[Herodotus] |- Bean [OAuth2 Resource Server Spec Customizer] Configure.");
        return customizer;
    }

    @Bean
    @ConditionalOnMissingBean
    public SecurityAttributeAnalyzer securityAttributeAnalyzer(SecurityAttributeStorage securityAttributeStorage, ReactiveSecurityMatcherConfigurer reactiveSecurityMatcherConfigurer) {
        SecurityAttributeAnalyzer securityAttributeAnalyzer = new SecurityAttributeAnalyzer(securityAttributeStorage, reactiveSecurityMatcherConfigurer.getPermitAllAttributes());
        log.trace("[Herodotus] |- Bean [Security Attribute Analyzer] Configure.");
        return securityAttributeAnalyzer;
    }
}

