/*
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君) (herodotus@aliyun.com & www.herodotus.cn)
 *
 * Dante Engine licensed under the GNU LESSER GENERAL PUBLIC LICENSE 3.0;
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * <http://www.gnu.org/licenses/lgpl-3.0.html>
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.herodotus.stirrup.oauth2.authorization.reactive;

import cn.herodotus.stirrup.core.foundation.enums.Target;
import cn.herodotus.stirrup.oauth2.authorization.properties.OAuth2AuthorizationProperties;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.oauth2.server.resource.introspection.ReactiveOpaqueTokenIntrospector;

/**
 * <p>Description: Reactive 环境资源服务器自定义器 </p>
 *
 * @author : gengwei.zheng
 * @date : 2024/1/28 22:20
 */
public class OAuth2ResourceServerSpecCustomizer implements Customizer<ServerHttpSecurity.OAuth2ResourceServerSpec> {

    private final OAuth2AuthorizationProperties authorizationProperties;
    private final OAuth2ResourceServerProperties resourceServerProperties;
    private final ReactiveOpaqueTokenIntrospector opaqueTokenIntrospector;

    public OAuth2ResourceServerSpecCustomizer(OAuth2AuthorizationProperties authorizationProperties, OAuth2ResourceServerProperties resourceServerProperties) {
        this.authorizationProperties = authorizationProperties;
        this.resourceServerProperties = resourceServerProperties;
        this.opaqueTokenIntrospector = new HerodotusReactiveOpaqueTokenIntrospector(resourceServerProperties);
    }

    private boolean isRemoteValidate() {
        return this.authorizationProperties.getValidate() == Target.REMOTE;
    }

    @Override
    public void customize(ServerHttpSecurity.OAuth2ResourceServerSpec spec) {
        if (isRemoteValidate()) {
            spec
                    .opaqueToken(opaque -> opaque.introspector(opaqueTokenIntrospector));
        } else {
            // TODO: Reactive JWT Token 相关配置
            spec
                    .jwt(jwt -> jwt.jwkSetUri(resourceServerProperties.getJwt().getJwkSetUri()));
        }

        spec
                .accessDeniedHandler(new HerodotusServerAccessDeniedHandler())
                .authenticationEntryPoint(new HerodotusServerAuthenticationEntryPoint());
    }

//    public BearerTokenResolver createBearerTokenResolver() {
//        return new HerodotusBearerTokenResolver(this.jwtDecoder, this.opaqueTokenIntrospector, this.isRemoteValidate());
//    }
}
