/*
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君) (herodotus@aliyun.com & www.herodotus.cn)
 *
 * Dante Engine licensed under the GNU LESSER GENERAL PUBLIC LICENSE 3.0;
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * <http://www.gnu.org/licenses/lgpl-3.0.html>
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.herodotus.stirrup.oauth2.authorization.reactive;

import org.springframework.security.config.Customizer;
import org.springframework.security.config.web.server.ServerHttpSecurity;

/**
 * <p>Description: AuthorizeExchangeSpecCustomizer </p>
 *
 * @author : gengwei.zheng
 * @date : 2024/1/28 21:59
 */
public class OAuth2AuthorizeExchangeSpecCustomizer implements Customizer<ServerHttpSecurity.AuthorizeExchangeSpec> {

    private final ReactiveSecurityMatcherConfigurer reactiveSecurityMatcherConfigurer;
    private final ReactiveSecurityAuthorizationManager reactiveSecurityAuthorizationManager;

    public OAuth2AuthorizeExchangeSpecCustomizer(ReactiveSecurityMatcherConfigurer reactiveSecurityMatcherConfigurer, ReactiveSecurityAuthorizationManager reactiveSecurityAuthorizationManager) {
        this.reactiveSecurityMatcherConfigurer = reactiveSecurityMatcherConfigurer;
        this.reactiveSecurityAuthorizationManager = reactiveSecurityAuthorizationManager;
    }

    @Override
    public void customize(ServerHttpSecurity.AuthorizeExchangeSpec spec) {

        spec
                .pathMatchers(reactiveSecurityMatcherConfigurer.getStaticRequestMatchers()).permitAll()
                .pathMatchers(reactiveSecurityMatcherConfigurer.getPermitAllRequestMatchers()).permitAll()
                // TODO: Actuator 开放权限配置，支持 Spring Boot Admin 同时保持安全性
                .anyExchange().access(reactiveSecurityAuthorizationManager);
    }
}
