/*
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君) (herodotus@aliyun.com & www.herodotus.cn)
 *
 * Dante Engine licensed under the GNU LESSER GENERAL PUBLIC LICENSE 3.0;
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * <http://www.gnu.org/licenses/lgpl-3.0.html>
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.herodotus.stirrup.oauth2.authorization.reactive;

import cn.herodotus.stirrup.core.definition.domain.Result;
import cn.herodotus.stirrup.oauth2.core.exception.SecurityGlobalExceptionHandler;
import cn.herodotus.stirrup.web.reactive.utils.WebFluxUtils;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

/**
 * <p>Description: 自定义 Reactive 环境未认证处理 </p>
 *
 * @author : gengwei.zheng
 * @date : 2024/1/28 23:20
 */
public class HerodotusServerAuthenticationEntryPoint implements ServerAuthenticationEntryPoint {
    @Override
    public Mono<Void> commence(ServerWebExchange exchange, AuthenticationException exception) {
        String uri = exchange.getRequest().getURI().getPath();
        Result<String> result = SecurityGlobalExceptionHandler.resolveException(exception, uri);
        return WebFluxUtils.writeJsonResponse(exchange.getResponse(), result);
    }
}
