/*
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君) (herodotus@aliyun.com & www.herodotus.cn)
 *
 * Dante Engine licensed under the GNU LESSER GENERAL PUBLIC LICENSE 3.0;
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * <http://www.gnu.org/licenses/lgpl-3.0.html>
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.herodotus.stirrup.oauth2.authorization.definition;

import cn.herodotus.stirrup.oauth2.core.servlet.enums.PermissionExpression;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.dromara.hutool.extra.spring.SpringUtil;
import org.springframework.security.util.MethodInvocationUtils;

import java.io.Serializable;

/**
 * <p>Description: 自定义SecurityConfig </p>
 * <p>
 * 自定义SecurityConfig，主要为了构建无参数构造函数，以解决序列化出错问题
 *
 * @author : gengwei.zheng
 * @date : 2021/9/11 15:57
 */
public class HerodotusSecurityAttribute implements Serializable {

    private String expression;

    private String className;

    private String methodName;

    public HerodotusSecurityAttribute() {
    }

    public String getExpression() {
        return expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getClassName() {
        return className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethodName() {
        return methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public static HerodotusSecurityAttribute create(String expression, String className, String methodName) {
        HerodotusSecurityAttribute attribute = new HerodotusSecurityAttribute();
        attribute.setExpression(expression);
        attribute.setClassName(className);
        attribute.setMethodName(methodName);
        return attribute;
    }

    public static HerodotusSecurityAttribute createDefaultPermitAll() {
        HerodotusSecurityAttribute attribute = new HerodotusSecurityAttribute();
        attribute.setExpression(PermissionExpression.PERMIT_ALL.getValue());
        attribute.setClassName(HerodotusSecurityAttribute.class.getName());
        attribute.setMethodName("getExpression");
        return attribute;
    }

    public static MethodInvocation createMethodInvocation(HerodotusSecurityAttribute attribute) {
        try {
            Class<?> clazz = ClassUtils.getClass(attribute.getClassName());
            Object object = SpringUtil.getBean(clazz);

            if (ObjectUtils.isEmpty(object)) {
                return MethodInvocationUtils.createFromClass(new HerodotusSecurityAttribute(), HerodotusSecurityAttribute.class, attribute.getMethodName(), null, null);
            } else {
                return MethodInvocationUtils.createFromClass(object, clazz, attribute.getMethodName(), null, null);
            }
        } catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }

    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HerodotusSecurityAttribute that = (HerodotusSecurityAttribute) o;
        return Objects.equal(expression, that.expression);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(expression);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("attrib", expression)
                .toString();
    }
}
